/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.sapjvm;

import com.sap.core.js.monitoring.sapjvm.IVmInfoFactory;
import com.sap.core.js.monitoring.sapjvm.MemorySnapshot;
import com.sap.core.js.monitoring.sapjvm.MetricsDataCollector;
import com.sap.jvm.monitor.vm.VmTimeInfo;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpuUtilizationCalculator
extends MetricsDataCollector<MemorySnapshot> {
    private double processors;

    public CpuUtilizationCalculator(Timer timer, long updateInterval, long totalUpdateDuration, IVmInfoFactory vmInfoFactory) {
        super(timer, updateInterval, totalUpdateDuration, vmInfoFactory);
        this.processors = vmInfoFactory.getAvailableProcessors();
    }

    @Override
    public final void updateValues() {
        VmTimeInfo newTimeInfo = this.vmInfoFactory.getVmTimeInfo();
        MemorySnapshot snapshot = new MemorySnapshot();
        snapshot.setCpuTime(newTimeInfo.getCpuTime());
        snapshot.setProbeTimeMicro(System.nanoTime() / 1000L);
        this.buffer.add(snapshot);
    }

    public final Double getCpuPercentage(long interval) {
        if (interval > this.totalUpdateDuration) {
            throw new IllegalArgumentException("No Data available");
        }
        int numberOfProbes = (int)(interval / this.updateInterval);
        int first = this.buffer.elements() - numberOfProbes - 1;
        if (first >= 0) {
            MemorySnapshot lastProbe = (MemorySnapshot)this.buffer.getLast();
            MemorySnapshot firstProbe = (MemorySnapshot)this.buffer.get(first);
            double cpuRatio = this.calculateRatio(firstProbe, lastProbe);
            return cpuRatio * 100.0;
        }
        MemorySnapshot lastProbe = (MemorySnapshot)this.buffer.getLast();
        MemorySnapshot firstProbe = (MemorySnapshot)this.buffer.get(0);
        double cpuRatio = this.calculateRatio(firstProbe, lastProbe);
        return cpuRatio * 100.0;
    }

    private double calculateRatio(MemorySnapshot firstProbe, MemorySnapshot lastProbe) {
        long timeDifference = lastProbe.getProbeTimeMicro() - firstProbe.getProbeTimeMicro();
        if (timeDifference == 0L) {
            return 0.0;
        }
        double deltaCpuTime = lastProbe.getCpuTime() - firstProbe.getCpuTime();
        return deltaCpuTime / this.processors / (double)timeDifference;
    }
}

