/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.sapjvm;

import com.sap.core.js.monitoring.sapjvm.GCSnapshot;
import com.sap.core.js.monitoring.sapjvm.IVmInfoFactory;
import com.sap.core.js.monitoring.sapjvm.MetricsDataCollector;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCNumberCalculator
extends MetricsDataCollector<GCSnapshot> {
    public GCNumberCalculator(Timer timer, long updateInterval, long totalUpdateDuration, IVmInfoFactory vmInfoFactory) {
        super(timer, updateInterval, totalUpdateDuration, vmInfoFactory);
    }

    public final Long getGCFrequency(long interval) {
        if (interval > this.totalUpdateDuration) {
            throw new IllegalArgumentException("No Data available");
        }
        int numberOfProbes = (int)(interval / this.updateInterval);
        int first = this.buffer.elements() - numberOfProbes - 1;
        if (first >= 0) {
            GCSnapshot lastProbe = (GCSnapshot)this.buffer.getLast();
            GCSnapshot firstProbe = (GCSnapshot)this.buffer.get(first);
            return this.calculateFrequency(firstProbe, lastProbe);
        }
        GCSnapshot lastProbe = (GCSnapshot)this.buffer.getLast();
        GCSnapshot firstProbe = (GCSnapshot)this.buffer.get(0);
        return this.calculateFrequency(firstProbe, lastProbe);
    }

    private long calculateFrequency(GCSnapshot firstProbe, GCSnapshot lastProbe) {
        return lastProbe.getGcNumber() - firstProbe.getGcNumber();
    }

    @Override
    public final void updateValues() {
        GCSnapshot snapshot = new GCSnapshot();
        snapshot.setGcNumber(this.vmInfoFactory.getVmMemoryInfo().getFullGcNr());
        this.buffer.add(snapshot);
    }
}

