/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.sapjvm;

import com.sap.core.js.monitoring.sapjvm.GCSnapshot;
import com.sap.core.js.monitoring.sapjvm.IVmInfoFactory;
import com.sap.core.js.monitoring.sapjvm.MetricsDataCollector;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCPercentageCalculator
extends MetricsDataCollector<GCSnapshot> {
    public GCPercentageCalculator(Timer timer, long updateInterval, long totalUpdateDuration, IVmInfoFactory vmInfoFactory) {
        super(timer, updateInterval, totalUpdateDuration, vmInfoFactory);
    }

    public final Double getGCRatio(long interval) {
        if (interval > this.totalUpdateDuration) {
            throw new IllegalArgumentException("No Data available");
        }
        int numberOfProbes = (int)(interval / this.updateInterval);
        int first = this.buffer.elements() - numberOfProbes - 1;
        if (first >= 0) {
            GCSnapshot lastProbe = (GCSnapshot)this.buffer.getLast();
            GCSnapshot firstProbe = (GCSnapshot)this.buffer.get(first);
            return this.calculateRatio(firstProbe, lastProbe);
        }
        GCSnapshot lastProbe = (GCSnapshot)this.buffer.getLast();
        GCSnapshot firstProbe = (GCSnapshot)this.buffer.get(0);
        return this.calculateRatio(firstProbe, lastProbe);
    }

    private double calculateRatio(GCSnapshot firstProbe, GCSnapshot lastProbe) {
        long timeDifference = lastProbe.getProbeTimeMicro() - firstProbe.getProbeTimeMicro();
        if (timeDifference == 0L) {
            return 0.0;
        }
        long gcDifference = lastProbe.getGcTimeMicro() - firstProbe.getGcTimeMicro();
        return 100.0 * (double)gcDifference / (double)timeDifference;
    }

    @Override
    public final void updateValues() {
        GCSnapshot snapshot = new GCSnapshot();
        snapshot.setGcTimeMicro(this.vmInfoFactory.getVmMemoryInfo().getGcDuration());
        snapshot.setProbeTimeMicro(System.nanoTime() / 1000L);
        this.buffer.add(snapshot);
    }
}

