/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.sapjvm;

import com.sap.core.js.monitoring.sapjvm.IVmInfoFactory;
import com.sap.core.js.monitoring.sapjvm.RingBuffer;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetricsDataCollector<Item> {
    protected RingBuffer<Item> buffer;
    protected RingBuffer<Item> buffer2;
    protected RingBuffer<Item> buffer3;
    protected IVmInfoFactory vmInfoFactory;
    protected long totalUpdateDuration;
    protected long updateInterval;
    protected int numberOfProbes;
    private Timer timer;
    private TimerTask updateTask = new TimerTask(){

        public void run() {
            MetricsDataCollector.this.updateValues();
        }
    };

    public MetricsDataCollector(Timer timer, long updateInterval, long totalUpdateDuration, IVmInfoFactory vmInfoFactory) {
        this.vmInfoFactory = vmInfoFactory;
        this.totalUpdateDuration = totalUpdateDuration;
        this.updateInterval = updateInterval;
        this.numberOfProbes = (int)(totalUpdateDuration / updateInterval + 1L);
        this.buffer = new RingBuffer(this.numberOfProbes);
        this.buffer2 = new RingBuffer(this.numberOfProbes);
        this.buffer3 = new RingBuffer(this.numberOfProbes);
        this.timer = timer;
        this.timer.scheduleAtFixedRate(this.updateTask, 0L, updateInterval);
    }

    public abstract void updateValues();
}

