/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.sapjvm;

import com.sap.core.js.monitoring.sapjvm.IVmInfoFactory;
import com.sap.core.js.monitoring.sapjvm.MetricsDataCollector;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFaultCalculator
extends MetricsDataCollector<Long> {
    public PageFaultCalculator(Timer timer, long updateInterval, long totalUpdateDuration, IVmInfoFactory vmInfoFactory) {
        super(timer, updateInterval, totalUpdateDuration, vmInfoFactory);
    }

    @Override
    public final void updateValues() {
        VmMemoryInfo newMemoryInfo = this.vmInfoFactory.getVmMemoryInfo();
        this.buffer.add(newMemoryInfo.getGcPageFaults());
    }

    public final Long getPageFaults(long interval) {
        if (interval > this.totalUpdateDuration) {
            throw new IllegalArgumentException("No Data available");
        }
        int numberOfProbes = (int)(interval / this.updateInterval);
        int first = this.buffer.elements() - numberOfProbes - 1;
        if (first >= 0) {
            Long lastProbe = (Long)this.buffer.getLast();
            Long firstProbe = (Long)this.buffer.get(first);
            return lastProbe - firstProbe;
        }
        Long lastProbe = (Long)this.buffer.getLast();
        Long firstProbe = (Long)this.buffer.get(0);
        return lastProbe - firstProbe;
    }
}

