/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.sapjvm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingBuffer<Item> {
    private int size;
    private Item[] buffer;
    private int last;
    private int elements;

    public RingBuffer(int size) {
        this.size = size;
        this.buffer = new Object[size];
        this.last = 0;
    }

    public final synchronized void add(Item i) {
        this.buffer[this.last] = i;
        this.last = (this.last + 1) % this.size;
        this.elements = this.elements < this.size ? this.elements + 1 : this.size;
    }

    public final synchronized Item get(int idx) {
        if (idx >= this.elements) {
            throw new ArrayIndexOutOfBoundsException("Attempt to access " + idx + " element of array with length " + this.elements);
        }
        if (this.elements < this.size) {
            return this.buffer[idx];
        }
        int pos = (this.last + idx) % this.size;
        return this.buffer[pos];
    }

    public final synchronized Item getLast() {
        return this.get(this.elements - 1);
    }

    public final synchronized int elements() {
        return this.elements;
    }
}

