/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.sapjvm;

import com.sap.core.js.monitoring.MBeanTimerFinalizer;
import com.sap.core.js.monitoring.sapjvm.SAPJVMMetricsHelper;
import com.sap.core.js.monitoring.sapjvm.SAPJVMMetricsMBean;
import com.sap.core.js.monitoring.sapjvm.VmInfoFactory;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

public class SAPJVMMetrics
extends StandardMBean
implements SAPJVMMetricsMBean,
MBeanTimerFinalizer {
    public static final long INTERVAL_1_MIN = 60000L;
    public static final long INTERVAL_5_MIN = 300000L;
    public static final long INTERVAL_15_MIN = 900000L;
    private static final String JVM_VENDOR = "SAP AG";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String COUNT_FULL_GC = "CountFullGC";
    private static final String COUNT_FULL_GC_DESCRIPTION = "Number of full GCs since the JVM started.";
    private static final String COUNT_GC_PAGE_FAULTS_5_MIN = "CountGCPageFaults5Min";
    private static final String COUNT_GC_PAGE_FAULTS_5_MIN_DESCRIPTION = "Disk swapping during GC in the last 5 minutes.";
    private static final String COUNT_GC_PAGE_FAULTS_15_MIN = "CountGCPageFaults15Min";
    private static final String COUNT_GC_PAGE_FAULTS_15_MIN_DESCRIPTION = "Disk swapping during GC in the last 15 minutes.";
    private static final String COUNT_WAITING_THREADS = "CountWaitingThreads";
    private static final String COUNT_WAITING_THREADS_DESCRIPTION = "Total number of threads waiting to obtain a shared resource.";
    private static final String RATIO_CPU_USAGE_MIN = "RatioCPUUsageMin";
    private static final String RATIO_CPU_USAGE_MIN_DESCRIPTION = "Average CPU usage % in the last minute.";
    private static final String RATIO_GC_TIME = "RatioGCTime";
    private static final String RATIO_GC_TIME_DESCRIPTION = "Ratio of the Application Execution time vs. GC execution time in the last 5 minutes.";
    private static final String FREQUENCY_GC = "FrequencyGC";
    private static final String FREQUENCY_GC_DESCRIPTION = "Number of GCs per minute.";
    private static final String JVM_DEBUG_INFO = "JVMDebugInfo";
    private static final String JVM_DEBUG_INFO_DESCRIPTION = "Extensive debug state information. Includes state, port and attached client (if available).";
    private static final String JVM_TRACE_FLAGS = "JVMTraceFlags";
    private static final String JVM_TRACE_FLAGS_DESCRIPTION = "Set of trace flags currently turned on for the SAP JVM.";
    private static final String ATTRIBUTE_NOT_FOUND_EXCEPTION_MESSAGE = "The specified attribute cannot be retrieved. The JVM is not SAP JVM.";
    private SAPJVMMetricsHelper sapJVMMetricsHelper;
    private boolean isSAPJVM = false;
    static final Logger logger = Logger.getLogger(SAPJVMMetrics.class);

    public SAPJVMMetrics() {
        super(SAPJVMMetricsMBean.class, false);
        String javaVendor = System.getProperty(JAVA_VENDOR);
        Logger logger = Logger.getLogger(SAPJVMMetrics.class);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("JVM Vendor is: " + javaVendor));
        }
        if (JVM_VENDOR.equals(javaVendor)) {
            this.sapJVMMetricsHelper = new SAPJVMMetricsHelper(new VmInfoFactory());
            this.isSAPJVM = true;
        }
    }

    public final String getJVMDebugInfo() throws AttributeNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getJVMDebugInfo operation is invoked.");
        }
        if (this.isSAPJVM) {
            return this.sapJVMMetricsHelper.debugInfo();
        }
        throw new AttributeNotFoundException(ATTRIBUTE_NOT_FOUND_EXCEPTION_MESSAGE);
    }

    public final long getCountFullGC() throws AttributeNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getCountFullGC operation is invoked.");
        }
        if (this.isSAPJVM) {
            return this.sapJVMMetricsHelper.memoryInfo().getFullGcNr();
        }
        throw new AttributeNotFoundException(ATTRIBUTE_NOT_FOUND_EXCEPTION_MESSAGE);
    }

    public final long getFrequencyGC() throws AttributeNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getFrequencyGC operation is invoked.");
        }
        if (this.isSAPJVM) {
            return this.sapJVMMetricsHelper.getGcNumberCalculator().getGCFrequency(60000L);
        }
        throw new AttributeNotFoundException(ATTRIBUTE_NOT_FOUND_EXCEPTION_MESSAGE);
    }

    public final long getCountGCPageFaults5Min() throws AttributeNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getCountGCPageFaults5Min operation is invoked.");
        }
        if (this.isSAPJVM) {
            return this.sapJVMMetricsHelper.getPageFaultCalculator().getPageFaults(300000L);
        }
        throw new AttributeNotFoundException(ATTRIBUTE_NOT_FOUND_EXCEPTION_MESSAGE);
    }

    public final long getCountGCPageFaults15Min() throws AttributeNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getCountGCPageFaults15Min operation is invoked.");
        }
        if (this.isSAPJVM) {
            return this.sapJVMMetricsHelper.getPageFaultCalculator().getPageFaults(900000L);
        }
        throw new AttributeNotFoundException(ATTRIBUTE_NOT_FOUND_EXCEPTION_MESSAGE);
    }

    public final String getJVMTraceFlags() throws AttributeNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getJVMTraceFlags operation is invoked.");
        }
        if (this.isSAPJVM) {
            return this.sapJVMMetricsHelper.stateInfo().getTraceFlags().toString();
        }
        throw new AttributeNotFoundException(ATTRIBUTE_NOT_FOUND_EXCEPTION_MESSAGE);
    }

    public final int getCountWaitingThreads() throws AttributeNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getCountWaitingThreads operation is invoked.");
        }
        if (this.isSAPJVM) {
            return this.sapJVMMetricsHelper.getMonitorMetricsProvider().getLockContention();
        }
        throw new AttributeNotFoundException(ATTRIBUTE_NOT_FOUND_EXCEPTION_MESSAGE);
    }

    public final double getRatioCPUUsageMin() throws AttributeNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRatioCPUUsageMin operation is invoked.");
        }
        if (this.isSAPJVM) {
            return this.sapJVMMetricsHelper.getCpuUtilization().getCpuPercentage(60000L);
        }
        throw new AttributeNotFoundException(ATTRIBUTE_NOT_FOUND_EXCEPTION_MESSAGE);
    }

    public final double getRatioGCTime() throws AttributeNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRatioGCTime operation is invoked.");
        }
        if (this.isSAPJVM) {
            if (this.sapJVMMetricsHelper.isVmHasGCMethod()) {
                return this.sapJVMMetricsHelper.getGcPercentage().getGCRatio(300000L);
            }
            return 0.0;
        }
        throw new AttributeNotFoundException(ATTRIBUTE_NOT_FOUND_EXCEPTION_MESSAGE);
    }

    protected final String getDescription(MBeanAttributeInfo info) {
        String name = info.getName();
        if (COUNT_FULL_GC.equals(name)) {
            return COUNT_FULL_GC_DESCRIPTION;
        }
        if (COUNT_GC_PAGE_FAULTS_5_MIN.equals(name)) {
            return COUNT_GC_PAGE_FAULTS_5_MIN_DESCRIPTION;
        }
        if (COUNT_GC_PAGE_FAULTS_15_MIN.equals(name)) {
            return COUNT_GC_PAGE_FAULTS_15_MIN_DESCRIPTION;
        }
        if (COUNT_WAITING_THREADS.equals(name)) {
            return COUNT_WAITING_THREADS_DESCRIPTION;
        }
        if (RATIO_CPU_USAGE_MIN.equals(name)) {
            return RATIO_CPU_USAGE_MIN_DESCRIPTION;
        }
        if (RATIO_GC_TIME.equals(name)) {
            return RATIO_GC_TIME_DESCRIPTION;
        }
        if (FREQUENCY_GC.equals(name)) {
            return FREQUENCY_GC_DESCRIPTION;
        }
        if (JVM_DEBUG_INFO.equals(name)) {
            return JVM_DEBUG_INFO_DESCRIPTION;
        }
        if (JVM_TRACE_FLAGS.equals(name)) {
            return JVM_TRACE_FLAGS_DESCRIPTION;
        }
        return super.getDescription(info);
    }

    public void terminateTimers() {
        this.sapJVMMetricsHelper.terminateTimer();
    }
}

