/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.sapjvm;

import com.sap.core.js.monitoring.sapjvm.CpuUtilizationCalculator;
import com.sap.core.js.monitoring.sapjvm.GCNumberCalculator;
import com.sap.core.js.monitoring.sapjvm.GCPercentageCalculator;
import com.sap.core.js.monitoring.sapjvm.IVmInfoFactory;
import com.sap.core.js.monitoring.sapjvm.MonitorMetrics;
import com.sap.core.js.monitoring.sapjvm.PageFaultCalculator;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmStateInfo;
import java.util.Timer;
import org.apache.log4j.Logger;

public class SAPJVMMetricsHelper {
    private static final long GRACE_PERIOD = 5000L;
    private static final long UPDATE_INTERVAL = 20000L;
    private static final Logger logger = Logger.getLogger(SAPJVMMetricsHelper.class);
    private long tsMemoryInfo;
    private VmMemoryInfo memoryInfo;
    private long tsStateInfo;
    private VmStateInfo stateInfo;
    private long tsDebugInfo;
    private VmDebugInfo debugInfo;
    private GCPercentageCalculator gcPercentage;
    private MonitorMetrics monitorMetricsProvider;
    private CpuUtilizationCalculator cpuUtilization;
    private PageFaultCalculator pageFaultCalculator;
    private GCNumberCalculator gcNumberCalculator;
    private boolean vmHasGCMethod = false;
    private IVmInfoFactory vmInfoFactory;
    final Timer metricsTimer = new Timer();

    public SAPJVMMetricsHelper(IVmInfoFactory vmInfoFactory) {
        this.vmInfoFactory = vmInfoFactory;
        this.checkVMGcMethod();
        if (this.vmHasGCMethod) {
            this.gcPercentage = new GCPercentageCalculator(this.metricsTimer, 20000L, 300000L, vmInfoFactory);
        }
        this.monitorMetricsProvider = new MonitorMetrics(vmInfoFactory);
        this.memoryInfo();
        this.cpuUtilization = new CpuUtilizationCalculator(this.metricsTimer, 20000L, 60000L, vmInfoFactory);
        this.pageFaultCalculator = new PageFaultCalculator(this.metricsTimer, 20000L, 900000L, vmInfoFactory);
        this.gcNumberCalculator = new GCNumberCalculator(this.metricsTimer, 20000L, 60000L, vmInfoFactory);
    }

    private void checkVMGcMethod() {
        block2: {
            VmMemoryInfo vm = this.vmInfoFactory.getVmMemoryInfo();
            try {
                vm.getClass().getMethod("getGcDuration", new Class[0]);
                this.vmHasGCMethod = true;
            }
            catch (NoSuchMethodException nm) {
                if (!logger.isInfoEnabled()) break block2;
                logger.info((Object)"getGcDuration is not available in this SAP JVM implementation.", (Throwable)nm);
            }
        }
    }

    public final VmMemoryInfo memoryInfo() {
        long now = System.currentTimeMillis();
        if (this.memoryInfo == null || now > this.tsMemoryInfo + 5000L) {
            this.memoryInfo = this.vmInfoFactory.getVmMemoryInfo();
            this.tsMemoryInfo = now;
        }
        return this.memoryInfo;
    }

    public final VmStateInfo stateInfo() {
        long now = System.currentTimeMillis();
        if (this.stateInfo == null || now > this.tsStateInfo + 5000L) {
            this.stateInfo = this.vmInfoFactory.getVmStateInfo();
            this.tsStateInfo = now;
        }
        return this.stateInfo;
    }

    public final String debugInfo() {
        long now = System.currentTimeMillis();
        if (this.debugInfo == null || now > this.tsDebugInfo + 5000L) {
            this.debugInfo = this.vmInfoFactory.getVmDebugInfo();
            this.tsDebugInfo = now;
        }
        StringBuffer sb = new StringBuffer();
        int port = this.debugInfo.getDebugPort();
        String client = this.debugInfo.getDebugClient();
        sb.append(this.debugInfo.getDebugState());
        if (port != -1) {
            sb.append(", port = ").append(port);
            if (client != null && client.length() > 0) {
                sb.append(", client = ").append(client);
            }
        }
        return sb.toString();
    }

    public final IVmInfoFactory getVmInfoFactory() {
        return this.vmInfoFactory;
    }

    public final PageFaultCalculator getPageFaultCalculator() {
        return this.pageFaultCalculator;
    }

    public final MonitorMetrics getMonitorMetricsProvider() {
        return this.monitorMetricsProvider;
    }

    public final CpuUtilizationCalculator getCpuUtilization() {
        return this.cpuUtilization;
    }

    public final GCPercentageCalculator getGcPercentage() {
        return this.gcPercentage;
    }

    public final GCNumberCalculator getGcNumberCalculator() {
        return this.gcNumberCalculator;
    }

    public final boolean isVmHasGCMethod() {
        return this.vmHasGCMethod;
    }

    public void terminateTimer() {
        if (this.metricsTimer != null) {
            this.metricsTimer.cancel();
        }
    }
}

