/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.sapjvm.debug;

import com.sap.core.js.monitoring.sapjvm.debug.DebugMBean;
import com.sap.jvm.monitor.vm.DebugState;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmFactory;
import com.sap.jvm.monitor.vm.VmInfo;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

public class DebugOperations
extends StandardMBean
implements DebugMBean {
    static final Logger logger = Logger.getLogger(DebugOperations.class);

    public DebugOperations() {
        super(DebugMBean.class, false);
    }

    public String startDebug() throws Exception {
        logger.debug((Object)"startDebug operation is invoked.");
        Vm vm = VmFactory.getCurrentVm();
        vm.startDebug(SuspendPolicy.SUSPEND_NONE);
        Integer dbgport = null;
        long t0 = System.currentTimeMillis();
        long ttw = 50L;
        while (ttw < 1000L) {
            VmDebugInfo dbgInfo = VmInfo.getDebugInfo();
            int port = dbgInfo.getDebugPort();
            if (port > 0) {
                dbgport = port;
                break;
            }
            Thread.sleep(ttw);
            ttw += 100L;
        }
        VmDebugInfo dbgi = VmInfo.getDebugInfo();
        DebugState dbgs = dbgi.getDebugState();
        if (dbgport == null) {
            double dt = System.currentTimeMillis() - t0;
            int dt_sec = (int)(dt / 1000.0);
            return "Unable to determine debug port after " + dt_sec + " seconds. Debug state: " + dbgs.name();
        }
        return String.valueOf(dbgs.name()) + ", Debug port:" + String.valueOf(dbgport);
    }

    public void stopDebug() throws Exception {
        logger.debug((Object)"stopDebug operation is invoked.");
        Vm vm = VmFactory.getCurrentVm();
        vm.stopDebug();
    }

    public String state() throws Exception {
        logger.debug((Object)"state operation is invoked.");
        VmDebugInfo dbgInfo = VmInfo.getDebugInfo();
        DebugState dbgState = dbgInfo.getDebugState();
        return dbgState.getDescription();
    }
}

