/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.threading;

import com.sap.core.js.monitoring.threading.ThreadDumpStrategy;
import com.sap.jvm.monitor.vm.Vm;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReflectionBasedThreadDumpStrategy
implements ThreadDumpStrategy {
    private final Method method;
    private final Vm vm;

    public ReflectionBasedThreadDumpStrategy(Method method, Vm vm) {
        this.method = method;
        this.vm = vm;
    }

    @Override
    public List<String> performThreadDump() throws IOException {
        try {
            List result = (List)this.method.invoke((Object)this.vm, new Object[0]);
            if (result != null) {
                return result;
            }
            return new ArrayList<String>(1);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e.getCause());
        }
    }
}

