/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.threading;

import com.sap.core.js.monitoring.sapjvm.IVmInfoFactory;
import com.sap.core.js.monitoring.threading.ReflectionBasedThreadDumpStrategy;
import com.sap.core.js.monitoring.threading.ThreadDumpStrategy;
import com.sap.jvm.monitor.vm.Vm;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAPJVMThreadDumpHelper {
    private static final Logger logger = Logger.getLogger(SAPJVMThreadDumpHelper.class);
    private static final String TAKE_THREAD_DUMP_METHOD_NAME = "getStackDump";
    IVmInfoFactory vmInfoFactory;

    public SAPJVMThreadDumpHelper(IVmInfoFactory vmInfoFactory) {
        this.vmInfoFactory = vmInfoFactory;
    }

    final List<String> getStacktrace() throws IOException {
        ThreadDumpStrategy threadDumpStrategy = this.createThreadDumpStrategy();
        return threadDumpStrategy.performThreadDump();
    }

    private ThreadDumpStrategy createThreadDumpStrategy() {
        try {
            Method method = Vm.class.getMethod(TAKE_THREAD_DUMP_METHOD_NAME, new Class[0]);
            Class<?> returnType = method.getReturnType();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 0) {
                this.throwUnsupportedDumpStacktraceMethodException(method);
            }
            Vm vm = this.vmInfoFactory.getVm();
            if (List.class.isAssignableFrom(returnType)) {
                return new ReflectionBasedThreadDumpStrategy(method, vm);
            }
            return this.throwUnsupportedDumpStacktraceMethodException(method);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ThreadDumpStrategy throwUnsupportedDumpStacktraceMethodException(Method method) {
        Class<?> returnType = method.getReturnType();
        Object[] parameterTypes = method.getParameterTypes();
        Object[] exceptionTypes = method.getExceptionTypes();
        throw new IllegalStateException("Unsupported interface for " + method.getName() + "(): " + returnType.getCanonicalName() + " " + method.getName() + "(" + Arrays.toString(parameterTypes) + ") throws " + Arrays.toString(exceptionTypes));
    }
}

