/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.threading;

import java.io.File;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ThreadDumpFileComparator
implements Comparator<File> {
    ThreadDumpFileComparator() {
    }

    @Override
    public int compare(File first, File second) {
        int firstSequence = this.getThreadDumpSequence(first);
        int secondSequence = this.getThreadDumpSequence(second);
        return this.compareInt(secondSequence, firstSequence);
    }

    private int getThreadDumpSequence(File threadDump) {
        int positionEnd;
        String fileName = threadDump.getName();
        int positionStart = fileName.indexOf(".");
        int sequenceNumber = 0;
        if (positionStart > 0 && (positionEnd = fileName.indexOf(".", positionStart + 1)) > 0) {
            sequenceNumber = Integer.parseInt(fileName.substring(positionStart + 1, positionEnd));
        }
        return sequenceNumber;
    }

    private int compareInt(int x, int y) {
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        return 0;
    }
}

