/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.threading;

import com.sap.core.js.monitoring.sapjvm.VmInfoFactory;
import com.sap.core.js.monitoring.threading.SAPJVMThreadDumpHelper;
import com.sap.core.js.monitoring.threading.ThreadDumpFileComparator;
import com.sap.core.js.monitoring.threading.ThreadDumpFileFilter;
import com.sap.core.js.monitoring.threading.ThreadingMBean;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Threading
extends StandardMBean
implements ThreadingMBean {
    static final Logger logger = Logger.getLogger(Threading.class);
    static final int NUMBER_OF_THREAD_DUMPS_TO_PRESERVE = 5;
    static final String THREAD_DUMP_FILE_NAME = "thread_dump";
    static final String THREAD_DUMP_FILE_EXTENSION = "txt";
    private static final String JVM_VENDOR = "SAP AG";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String THREAD_DUMP_FILE_LOCATION = "/log/thread_dump.txt";
    private boolean isSAPJVM = false;
    private SAPJVMThreadDumpHelper sapJVMThreadDump;

    public Threading() {
        super(ThreadingMBean.class, false);
        String javaVendor = System.getProperty(JAVA_VENDOR);
        if (JVM_VENDOR.equals(javaVendor)) {
            this.sapJVMThreadDump = new SAPJVMThreadDumpHelper(new VmInfoFactory());
            this.isSAPJVM = true;
        }
    }

    @Override
    public String dumpStacktrace() throws IOException {
        logger.debug((Object)"dumpStacktrace operation is invoked.");
        File threadDumpFile = this.getThreadDumpFile();
        if (this.isSAPJVM) {
            List<String> threadsStacktrace = this.sapJVMThreadDump.getStacktrace();
            this.writeToFile(threadsStacktrace, threadDumpFile);
        } else {
            String pid = this.getPID();
            File jdk = this.getSunJDKFile();
            String command = "jstack " + pid;
            Process exec = Runtime.getRuntime().exec(command, null, jdk);
            this.redirectDataToFile(exec, threadDumpFile);
        }
        return this.getNormalizedAbsoluteFilePath(threadDumpFile);
    }

    private String getNormalizedAbsoluteFilePath(File threadDumpFile) {
        String currentDirStr = "." + File.separatorChar;
        String absPath = threadDumpFile.getAbsolutePath();
        StringBuffer absPathStrBuf = new StringBuffer(absPath);
        int index = absPath.indexOf(currentDirStr);
        if (index != -1) {
            absPathStrBuf.delete(index, index + currentDirStr.length());
        }
        return absPathStrBuf.toString();
    }

    private void redirectDataToFile(Process exec, File logFile) throws IOException {
        DataInputStream ls_in = null;
        try {
            String ls_str;
            ls_in = new DataInputStream(exec.getInputStream());
            ArrayList<String> threadsInfo = new ArrayList<String>();
            while ((ls_str = ls_in.readLine()) != null) {
                threadsInfo.add(ls_str);
            }
            this.writeToFile(threadsInfo, logFile);
        }
        catch (Throwable throwable) {
            if (ls_in != null) {
                try {
                    ls_in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (ls_in != null) {
            try {
                ls_in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeToFile(List<String> threadsInfo, File logFile) throws IOException {
        this.rotateThreadDumps(logFile);
        FileWriter fw = null;
        try {
            fw = new FileWriter(logFile);
            for (String threadStacktrace : threadsInfo) {
                fw.write(String.valueOf(threadStacktrace) + "\n");
            }
        }
        catch (Throwable throwable) {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fw != null) {
            try {
                fw.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void rotateThreadDumps(File logFile) throws IOException {
        if (logFile.exists()) {
            File threadDumpDirectory = this.getParentDirectory(logFile);
            File[] allThreadDumps = this.getAllThreadDumps(threadDumpDirectory);
            int numberOfThreadDumps = allThreadDumps.length;
            int i = 0;
            while (i < allThreadDumps.length) {
                File threadDump = allThreadDumps[i];
                if (numberOfThreadDumps > 5) {
                    this.deleteThreadDump(threadDump);
                    --numberOfThreadDumps;
                } else {
                    int currentDumpSequence = allThreadDumps.length - i;
                    this.renameThreadDump(threadDump, currentDumpSequence);
                }
                ++i;
            }
        }
    }

    private File getParentDirectory(File file) {
        File fileFromAbsolutePath = new File(file.getAbsolutePath());
        return fileFromAbsolutePath.getParentFile();
    }

    private File[] getAllThreadDumps(File threadDumpDirectory) {
        File[] allThreadDumps = threadDumpDirectory.listFiles(new ThreadDumpFileFilter(THREAD_DUMP_FILE_NAME, THREAD_DUMP_FILE_EXTENSION));
        Arrays.sort(allThreadDumps, new ThreadDumpFileComparator());
        return allThreadDumps;
    }

    private void deleteThreadDump(File threadDump) throws IOException {
        if (threadDump.exists() && !threadDump.delete()) {
            throw new IOException("Cannot delete thread dump: " + threadDump);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Thread dump deleted: " + threadDump.getAbsolutePath()));
        }
    }

    private void renameThreadDump(File threadDump, int threadDumpNumber) throws IOException {
        File renamedThreadDump = this.resolveThreadDumpFileName(threadDump, threadDumpNumber);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Renaming thread dump from: " + threadDump + "\t to: " + renamedThreadDump));
        }
        if (!threadDump.renameTo(renamedThreadDump)) {
            throw new IOException("Cannot rename the thread dump: " + threadDump.getAbsolutePath());
        }
    }

    private File resolveThreadDumpFileName(File threadDump, int threadDumpNumber) {
        File parentDirectory = this.getParentDirectory(threadDump);
        return new File(parentDirectory, "thread_dump." + threadDumpNumber + "." + THREAD_DUMP_FILE_EXTENSION);
    }

    private File getSunJDKFile() throws IOException {
        File jdk = new File(System.getProperty("java.home"));
        if (jdk.getName().toLowerCase(Locale.ENGLISH).equals("jre")) {
            jdk = new File(jdk.getParent(), "bin");
        } else if (!jdk.getName().toLowerCase(Locale.ENGLISH).equals("bin")) {
            jdk = new File(jdk, "bin");
        }
        return jdk;
    }

    private String getPID() {
        String pidAndHost = ManagementFactory.getRuntimeMXBean().getName();
        String[] parts = pidAndHost.split("@");
        return parts[0];
    }

    private File getThreadDumpFile() {
        String serverConfigHome = System.getProperty("server.config.home");
        if (serverConfigHome == null || !new File(serverConfigHome).exists()) {
            serverConfigHome = ".";
        }
        return new File(String.valueOf(serverConfigHome) + THREAD_DUMP_FILE_LOCATION);
    }
}

