/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.internal.api.client;

import com.sap.core.connectivity.apiext.internal.api.client.ConnectTimeoutException;
import com.sap.core.connectivity.apiext.internal.api.client.ConnectivityClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BasicOperation<T>
implements ConnectivityClient.Operation<T> {
    private static final String UTF_8 = "UTF-8";
    private static final Logger log = Logger.getLogger(BasicOperation.class.getName());

    @Override
    public final T execute(HttpURLConnection connection) throws IOException {
        this.prepare(connection);
        this.connect(connection);
        return this.executeImpl(connection);
    }

    protected abstract void prepare(HttpURLConnection var1) throws IOException;

    protected abstract T executeImpl(HttpURLConnection var1) throws IOException;

    protected String readResponse(HttpURLConnection connection) throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, String.format("Reading response from URL [%s]", connection.getURL()));
        }
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
        }
        catch (IOException iOException) {
            inputStream = connection.getErrorStream();
        }
        String response = null;
        if (inputStream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, UTF_8));){
                String line = null;
                StringBuilder responseBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    responseBuilder.append(line);
                }
                response = responseBuilder.toString();
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, String.format("Read response from URL [%s]: [%s]", connection.getURL(), response));
        }
        return response;
    }

    private void connect(HttpURLConnection connection) throws IOException {
        try {
            connection.connect();
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException(ex.getMessage());
        }
    }
}

