/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.config.cmd;

import com.beust.jcommander.Parameter;
import com.sap.core.connectivity.config.cmd.Constants;
import com.sap.core.connectivity.config.cmd.helper.CheckHelper;
import com.sap.core.connectivity.config.cmd.helper.DumpHelper;
import com.sap.core.utils.security.logon.BasicAuthHttpClientProvider;
import com.sap.jpaas.infrastructure.console.command.RemoteCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.validator.SACValidator;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public abstract class ConfigurationConsoleCommand
extends RemoteCommand {
    public static final String ERROR_COMPOUND_PARAMS = "Conflicting instructions. When using the complex form of {0}, the value must be in format <provider_account>:<provider_application>";
    @Parameter(names={"-space", "--space"}, description="Space", validateWith=SACValidator.class, hidden=true)
    protected String deprecated_space;
    @Parameter(names={"-appliance", "--appliance"}, description="Appliance", validateWith=SACValidator.class, hidden=true)
    protected String deprecated_appliance;
    @Parameter(names={"-service", "--service"}, description="Name of service for which destination or keystore file will be deployed", hidden=true)
    protected String service = "connectivity";
    @Parameter(names={"-provider-application", "--provider-application"}, description="Refers to an application provided by the account specified with the --provider-account parameter. Required if provider account is specified.", hidden=true)
    protected String providerApplication;
    @Parameter(names={"-provider-account", "--provider-account"}, description="Refers to the account providing an application specified with the --provider-application parameter. Required if configuring a provider application.", hidden=true)
    protected String providerAccount;
    protected HttpClient httpclient = null;
    @Parameter(names={"-a", "-account", "--account"}, description="Your account. The account for which you provide username and password", validateWith=SACValidator.class)
    protected String account;
    @Parameter(names={"-c", "-component", "--component"}, description="Component", validateWith=SACValidator.class, hidden=true)
    protected String component = "web";

    @Override
    public void init() throws CommandException {
        super.init();
        this.initCompoundParams();
        CheckHelper.validateSpaceAccountArguments(this.deprecated_space, this.account);
        if (this.deprecated_space != null) {
            this.account = this.deprecated_space;
        }
        CheckHelper.validateApplianceApplicationArguments(this.deprecated_appliance, this.getApplication());
        if (this.deprecated_appliance != null) {
            this.setApplication(this.deprecated_appliance);
        }
        CheckHelper.checkSACSpecified(this.account, this.getApplication(), this.providerAccount, this.providerApplication);
        CheckHelper.checkPropSpecified(this.user, "The parameter --user is missing.");
        CheckHelper.checkProviderPropsSpecified(this.providerAccount, this.providerApplication);
    }

    private void initCompoundParams() {
        int separatorPos;
        if (CheckHelper.isValueSpecified(this.getApplication()) && (separatorPos = this.getApplication().indexOf(":")) != -1) {
            String compoundValueProviderAccount = this.getApplication().substring(0, separatorPos);
            CheckHelper.checkPropSpecified(compoundValueProviderAccount, MessageFormat.format(ERROR_COMPOUND_PARAMS, "--application"));
            String compoundValueProviderApplication = this.getApplication().substring(separatorPos + 1);
            CheckHelper.checkPropSpecified(compoundValueProviderApplication, MessageFormat.format(ERROR_COMPOUND_PARAMS, "--application"));
            if (compoundValueProviderAccount.equals(this.account)) {
                this.providerAccount = null;
                this.providerApplication = null;
                this.setApplication(compoundValueProviderApplication);
            } else {
                this.setApplication(null);
                this.providerAccount = compoundValueProviderAccount;
                this.providerApplication = compoundValueProviderApplication;
            }
        }
    }

    protected void dumpOperation(String operationDumpString) {
        ArrayList argsList = new ArrayList();
        if (this.isOperationOnTenantLevel()) {
            Collections.addAll(argsList, "account", this.account, "host", this.host);
        } else {
            Collections.addAll(argsList, "application", this.getApplication(), "account", this.account, "host", this.host, "component", this.component, "provider_account", this.providerAccount, "provider_application", this.providerApplication);
        }
        com.sap.jpaas.infrastructure.console.util.DumpHelper.dumpOperationList(this.user, operationDumpString, argsList.toArray());
    }

    protected String getStringToAppendForDumpingOperation() {
        String appendString = " ";
        if (this.isOperationOnTenantLevel()) {
            appendString = "a specified account";
        } else if (this.isOperationOnApplicationLevel()) {
            appendString = "a particular application";
        } else if (this.isOperationOnSubscriptionLevel()) {
            appendString = "a particular application provided by another account";
        }
        appendString = appendString + ":";
        return appendString;
    }

    private boolean isOperationOnSubscriptionLevel() {
        return this.providerApplication != null;
    }

    private boolean isOperationOnApplicationLevel() {
        return this.providerApplication == null && this.getApplication() != null;
    }

    private boolean isOperationOnTenantLevel() {
        return this.getApplication() == null && this.providerApplication == null;
    }

    protected String getPath(String name) {
        String result = null;
        String baseConf = "base";
        String realHost = "";
        String prefix = "https://configapi";
        if (this.host.startsWith("https://configapi")) {
            int realHostLimit = this.host.indexOf(".");
            realHost = this.host.substring(realHostLimit + 1);
            prefix = this.host.substring(0, realHostLimit);
        } else if (this.host.startsWith("https://")) {
            realHost = this.host.substring("https://".length());
        } else if (this.host.startsWith("http://")) {
            DumpHelper.error("The parameter --host must start with 'https://'", 306);
        } else {
            realHost = this.host;
        }
        this.host = prefix + "." + realHost;
        if (!this.host.endsWith("/configuration/api/rest")) {
            this.host = this.host + "/configuration/api/rest";
        }
        if (name == null) {
            name = "";
        }
        if (this.providerAccount != null && this.providerApplication != null) {
            result = this.getPathForOperationOnSubscriptionLevel(name, baseConf);
        } else if (this.getApplication() != null) {
            result = this.getPathForOperationOnApplicationLevel(name, baseConf);
        } else {
            this.validatePropertiesForTenantLevelOperation();
            result = this.getPathForOperationOnTenantLevel(name);
        }
        return result;
    }

    private void validatePropertiesForTenantLevelOperation() {
    }

    private String getPathForOperationOnSubscriptionLevel(String name, String baseConf) {
        return this.host + '/' + "SPACES" + '/' + this.account + '/' + "appliances" + '/' + this.providerApplication + '/' + "components" + '/' + this.component + '/' + baseConf + '/' + this.service + '/' + "provideraccount" + '/' + this.providerAccount + '/' + "providerapplication" + '/' + this.providerApplication + '/' + name;
    }

    private String getPathForOperationOnApplicationLevel(String name, String baseConf) {
        return this.host + '/' + "SPACES" + '/' + this.account + '/' + "appliances" + '/' + this.getApplication() + '/' + "components" + '/' + this.component + '/' + baseConf + '/' + this.service + '/' + name;
    }

    private String getPathForOperationOnTenantLevel(String name) {
        return this.host + '/' + "SPACES" + '/' + this.account + '/' + this.service + '/' + name;
    }

    protected void checkStatusCode(int code, String message, String operationName) {
        if (code != 200) {
            String text = "Http error code while executing remote operation. Http code was: " + code + Constants.LINE_SEPARATOR + message + Constants.LINE_SEPARATOR;
            if (code == 403) {
                text = text + "The user " + this.user + " is not authorized for " + operationName + " operation.";
            }
            if (code == 503) {
                text = text + "Make sure the host name is correct, or contact system administrators for further support" + Constants.LINE_SEPARATOR;
            }
            throw new CommandException(text);
        }
        System.out.println("\nOperation " + operationName + " finished successfully.\n");
    }

    protected HttpClient createHttpClient(String url, String userName, String password, String fetchTokenUrl) throws IOException {
        if (this.httpclient == null) {
            this.httpclient = BasicAuthHttpClientProvider.createCsrfHttpClient(this.getHttpClient(), fetchTokenUrl);
        }
        return this.httpclient;
    }

    protected HttpClient createHttpClient(String url, String userName, String password) throws IOException {
        if (this.httpclient == null) {
            this.httpclient = this.getHttpClient();
        }
        return this.httpclient;
    }

    protected void releaseHttpClient() {
        if (this.httpclient != null && this.httpclient instanceof DefaultHttpClient) {
            this.httpclient.getConnectionManager().shutdown();
        }
    }

    public void setHttpClient(HttpClient defaultHttpclient) {
        this.httpclient = defaultHttpclient;
    }

    @Override
    public void cleanup() {
        this.releaseHttpClient();
    }

    public String getService() {
        return this.service;
    }

    @Override
    public String getGroup() {
        return "connectivity";
    }

    protected String parseResponseErrorContent(String htmlContent) {
        String headerBegin = "<h1>";
        String headerEnd = "</h1>";
        String responseDetailedError = htmlContent;
        String lowerCaseContent = htmlContent.toLowerCase();
        if (lowerCaseContent.contains(headerBegin) && lowerCaseContent.contains(headerEnd)) {
            responseDetailedError = htmlContent.substring(lowerCaseContent.indexOf(headerBegin) + 4, lowerCaseContent.indexOf(headerEnd));
        }
        return responseDetailedError;
    }

    protected String getContentMessage(HttpEntity resEntity) throws IOException {
        return EntityUtils.toString(resEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeResponse(HttpResponse response) throws IOException {
        HttpEntity resEntity = response.getEntity();
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            String statusMessage = response.getStatusLine().getReasonPhrase();
            if (statusCode != 200) {
                String fullMessage = this.getContentMessage(resEntity);
                this.checkStatusCode(statusCode, this.parseResponseErrorContent(fullMessage), this.getName());
            } else {
                this.checkStatusCode(statusCode, statusMessage, this.getName());
            }
        }
        finally {
            EntityUtils.consume(resEntity);
        }
    }

    public String getProviderAccount() {
        return this.providerAccount;
    }

    public String getProviderApplication() {
        return this.providerApplication;
    }

    public abstract String getApplication();

    protected abstract void setApplication(String var1);

    public String getAccount() {
        return this.account;
    }

    public String getComponent() {
        return this.component;
    }
}

