/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.config.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.connectivity.config.cmd.ConfigurationConsoleCommand;
import com.sap.core.connectivity.config.cmd.ConsoleCommandExample;
import com.sap.core.connectivity.config.cmd.helper.CheckHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;

@Parameters(commandDescription="Deletes destination or keystore file from SAP Cloud Platform")
public class DeleteAction
extends ConfigurationConsoleCommand {
    @Parameter(names={"-name", "--name"}, description="Name of destination or keystore file to be deleted")
    protected String name;
    @Parameter(names={"-b", "-application", "--application"}, description="The application for which you delete a destination. \n                       Syntax: \n                       1. '--application <myapp>' if the application runs in your account; \n                       2. '--application <provider_account>:<provider_app>' if the application runs in another account ")
    protected String application;

    @Override
    public void run() throws CommandException {
        this.verifyDeleteParams();
        String path = this.getPath(this.name);
        try {
            this.dumpOperation("Requesting delete-destination for " + this.getStringToAppendForDumpingOperation());
            HttpDelete request = new HttpDelete(path);
            this.delete(request);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    private void verifyDeleteParams() {
        CheckHelper.checkPropSpecified(this.name, "The parameter --name is missing.");
    }

    @Override
    public String getName() {
        return "delete-destination";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(HttpDelete request) throws IOException {
        try {
            String fetchTokenUrl = this.host + '/' + "SPACES" + '/' + this.account;
            this.createHttpClient(request.getURI().toString(), this.user, this.getPassword(), fetchTokenUrl);
            HttpResponse response = this.httpclient.execute(request);
            this.consumeResponse(response);
        }
        finally {
            this.cleanup();
        }
    }

    public String getNameParameter() {
        return this.name;
    }

    @Override
    public String getExample() {
        return ConsoleCommandExample.getDeleteActionExample();
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    protected void setApplication(String application) {
        this.application = application;
    }
}

