/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.config.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.connectivity.config.cmd.ConfigurationConsoleCommand;
import com.sap.core.connectivity.config.cmd.ConsoleCommandExample;
import com.sap.core.connectivity.config.cmd.Constants;
import com.sap.core.connectivity.config.cmd.PasswordKeys;
import com.sap.core.connectivity.config.cmd.helper.CheckHelper;
import com.sap.core.connectivity.config.cmd.helper.DumpHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

@Parameters(commandDescription="Downloads destination or keystore file to local file system")
public class GetAction
extends ConfigurationConsoleCommand {
    @Parameter(names={"-name", "--name"}, description="Name of destination or keystore file to be downloaded;if not set, names of all destination and keystore files for the service will be listed.")
    protected String name;
    @Parameter(names={"-localpath", "--localpath"}, description="Path on a file system where a destination configuration file or a keystore file will be downloaded to;if not set, no files will be downloaded")
    protected String localpath;
    @Parameter(names={"-b", "-application", "--application"}, description="The application for which you download a destination. \n                       Syntax: \n                       1. '--application <myapp>' if the application runs in your account; \n                       2. '--application <provider_account>:<provider_app>' if the application runs in another account ")
    protected String application;

    @Override
    public void run() throws CommandException {
        this.verifyGetParams();
        String path = this.getPath(this.name);
        if (path != null) {
            try {
                this.dumpOperation("Requesting get-destination for " + this.getStringToAppendForDumpingOperation());
                HttpGet request = new HttpGet(path);
                this.download(request, this.localpath, this.name);
            }
            catch (IOException e) {
                throw new CommandException(e);
            }
        }
    }

    private void verifyGetParams() {
        boolean nameSpecified = CheckHelper.isValueSpecified(this.name);
        boolean localpathSpecified = CheckHelper.isValueSpecified(this.localpath);
        if (!(nameSpecified && localpathSpecified || !nameSpecified && !localpathSpecified)) {
            DumpHelper.paramError(Constants.CONST_INCORRECT_PARAMS_GET, 307);
        }
    }

    @Override
    public String getName() {
        return "get-destination";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(HttpGet request, String localpath, String name) throws IOException {
        try {
            this.createHttpClient(request.getURI().toString(), this.user, this.getPassword());
            HttpResponse response = this.httpclient.execute(request);
            Header type = response.getFirstHeader("Content-Type");
            HttpEntity entity = response.getEntity();
            if (type != null) {
                if (type.getValue().equals("application/octet-stream") && entity != null) {
                    CheckHelper.checkPropSpecified(name, "The parameter --name is missing.");
                    CheckHelper.checkPropSpecified(localpath, "The parameter --localpath is missing.");
                    String resource = localpath + File.separator + name;
                    File file = new File(resource);
                    file.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(file);
                    entity.writeTo(fos);
                    fos.close();
                    this.removePasswordFromPropertyFle(file);
                }
                if (type.getValue().contains("text/plain")) {
                    System.out.println(EntityUtils.toString(entity));
                }
            }
            this.consumeResponse(response);
        }
        finally {
            this.cleanup();
        }
    }

    private void removePasswordFromPropertyFle(File file) {
        Properties props = new Properties();
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(file);
            props.load(input);
            input.close();
            boolean isPropertyFileConfiguration = false;
            for (PasswordKeys passKey : PasswordKeys.values()) {
                if (!props.containsKey(passKey.getValue())) continue;
                props.setProperty(passKey.getValue(), "");
                isPropertyFileConfiguration = true;
            }
            if (isPropertyFileConfiguration) {
                output = new FileOutputStream(file);
                props.store(output, null);
            }
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getLocalpath() {
        return this.localpath;
    }

    public String getNameParameter() {
        return this.name;
    }

    @Override
    public String getExample() {
        return ConsoleCommandExample.getGetActionExample();
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    protected void setApplication(String application) {
        this.application = application;
    }
}

