/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.config.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.core.connectivity.config.cmd.ConfigurationConsoleCommand;
import com.sap.core.connectivity.config.cmd.ConsoleCommandExample;
import com.sap.core.connectivity.config.cmd.helper.CheckHelper;
import com.sap.core.connectivity.config.cmd.validator.ConfigurationValidator;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;

@Parameters(commandDescription="Uploads destination or keystore file to SAP Cloud Platform")
public class PutAction
extends ConfigurationConsoleCommand {
    @Parameter(names={"-localpath", "--localpath"}, description="Path to a destination configuration property file or a keystore file on a local file system")
    protected String localpath;
    @Parameter(names={"-b", "-application", "--application"}, description="The application for which you upload a destination. \n                       Syntax: \n                       1. '--application <myapp>' if the application runs in your account; \n                       2. '--application <provider_account>:<provider_app>' if the application runs in another account ")
    protected String application;
    ConfigurationValidator confValidator = new ConfigurationValidator();

    @Override
    public void run() throws CommandException {
        this.verifyPutParams();
        String path = this.getPath(null);
        if (path != null) {
            this.checkForValidLocalpath(this.localpath);
            this.checkForValidProviderParams(this.providerAccount, this.providerApplication);
            this.dumpOperation("Requesting put-destination for " + super.getStringToAppendForDumpingOperation());
            HashSet<String> files = new HashSet<String>();
            files.add(new File(this.localpath).getAbsolutePath());
            try {
                HttpPost request = new HttpPost(path);
                this.upload(request, files);
            }
            catch (IOException e) {
                throw new CommandException(e);
            }
        }
    }

    private void verifyPutParams() {
        CheckHelper.checkPropSpecified(this.localpath, "The parameter --localpath is missing.");
    }

    protected void checkForValidLocalpath(String localpath) throws CommandException {
        this.confValidator.validate(localpath);
        if ("connectivity".equals(this.getService())) {
            this.confValidator.validateConnectivity(localpath);
        }
    }

    protected void checkForValidProviderParams(String providerAccount, String providerApplication) throws CommandException {
        ConfigurationValidator confValidator = new ConfigurationValidator();
        confValidator.validateProviderParams(providerAccount, providerApplication);
    }

    @Override
    public String getName() {
        return "put-destination";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(HttpPost request, Set<String> files) throws IOException {
        if (files != null && !files.isEmpty()) {
            try {
                String fetchTokenUrl = this.host + '/' + "SPACES" + '/' + this.account;
                this.createHttpClient(request.getURI().toString(), this.user, this.getPassword(), fetchTokenUrl);
                MultipartEntity reqEntity = new MultipartEntity();
                for (String filename : files) {
                    File file = new File(filename);
                    FileBody body = new FileBody(file);
                    String destinationName = this.confValidator.getDestinationName(file);
                    if (!destinationName.equals("")) {
                        reqEntity.addPart(destinationName, body);
                        continue;
                    }
                    reqEntity.addPart(file.getName(), body);
                }
                request.setEntity(reqEntity);
                HttpResponse response = this.httpclient.execute(request);
                this.consumeResponse(response);
            }
            finally {
                this.cleanup();
            }
        }
    }

    public String getLocalpath() {
        return this.localpath;
    }

    @Override
    public String getExample() {
        return ConsoleCommandExample.getPutActionExample();
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    protected void setApplication(String application) {
        this.application = application;
    }
}

