/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.config.cmd.helper;

import com.beust.jcommander.ParameterException;
import com.sap.core.connectivity.config.cmd.Constants;
import java.text.MessageFormat;

public class CheckHelper {
    public static void checkSACSpecified(String account, String application, String providerAccount, String providerApplication) throws ParameterException {
        if (!CheckHelper.isValueSpecified(account)) {
            throw new ParameterException("The parameter --account is missing.");
        }
        if (providerAccount != null && application != null) {
            throw new ParameterException(MessageFormat.format("Conflicting instructions. Specify either {0} or {1} but not both. Use {1} in combination with {2}", "--application", "--provider-account", "--provider-application"));
        }
        if (providerApplication != null && application != null) {
            throw new ParameterException(MessageFormat.format("Conflicting instructions. Specify either {0} or {1} but not both. Use {0} when targeting an application in your account. Use {1} when targeting an application provided to you by a third party; in this case specify {2} too.", "--application", "--provider-application", "--provider-account"));
        }
    }

    public static void validateSpaceAccountArguments(String space, String account) {
        if (CheckHelper.isValueSpecified(space) && CheckHelper.isValueSpecified(account)) {
            throw new ParameterException("Both --space and --account are specified");
        }
    }

    public static void validateApplianceApplicationArguments(String appliance, String application) {
        if (CheckHelper.isValueSpecified(appliance) && CheckHelper.isValueSpecified(application)) {
            throw new ParameterException("Both --appliance and --application are specified");
        }
    }

    public static boolean isValueSpecified(String value) {
        return value != null && !value.trim().isEmpty();
    }

    public static void dumpErrorMessage(String msg) {
        System.err.println(Constants.LINE_SEPARATOR + "ERROR: " + msg + Constants.LINE_SEPARATOR);
    }

    public static void checkPropSpecified(String propertyName, String errorMessage) throws ParameterException {
        if (!CheckHelper.isValueSpecified(propertyName)) {
            throw new ParameterException(errorMessage);
        }
    }

    public static void checkProviderPropsSpecified(String providerAccount, String providerApplication) throws ParameterException {
        if (providerAccount == null && providerApplication != null) {
            CheckHelper.checkPropSpecified(providerAccount, "Parameter --provider-account not specified. Add the name of the provider account in the --provider-account parameter");
        } else if (providerAccount != null && providerApplication == null) {
            CheckHelper.checkPropSpecified(providerApplication, "Parameter --provider-application not specified. Add the name of the application in the --provider-application parameter");
        }
    }
}

