/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.config.cmd.validator;

import com.sap.core.connectivity.config.cmd.Constants;
import com.sap.core.connectivity.config.cmd.helper.DumpHelper;
import com.sap.core.connectivity.config.cmd.validator.KeyStoreLocationValidator;
import com.sap.core.connectivity.config.cmd.validator.TrustStoreLocationValidator;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConfigurationValidator {
    private Logger LOGGER = Logger.getLogger(this.getClass());
    private static final String CHARACTER_ENCODING = "UTF-8";
    private static final String KEYSTORE_LOCATION_ERROR_MESSAGE = "The parameter --localpath is invalid.The provided file [%s] contains an invalid property.The value of the property '%s' does not have an allowed extension. Allowed extensions are: %s.";
    public static final Set<String> ALLOWED_EXTENSIONS;
    private KeyStoreLocationValidator keyStoreLocationValidator = new KeyStoreLocationValidator();
    private TrustStoreLocationValidator trustStoreLocationValidator = new TrustStoreLocationValidator();

    public void validate(String value) throws CommandException {
        File file = new File(value);
        if (!file.exists()) {
            this.LOGGER.debug("The specified configuration file " + value + " does not exist.");
            DumpHelper.error("The parameter --localpath is invalid. The file [" + value + "] could not be open.", 300);
        }
        if (file.isDirectory()) {
            this.LOGGER.debug("The specified configuration file " + value + " is a directory.");
            DumpHelper.error("Directory upload is not allowed.The provided value for --localpath points to a directory.", 301);
        }
        if (file.length() > (long)(Constants.FILE_SIZE_LIMIT * 1024 * 1024)) {
            this.LOGGER.debug("The specified configuration file " + value + " is too large.");
            DumpHelper.error("The parameter --localpath is invalid.The size of the provided file [" + value + "] " + "is larger than the limit of " + Constants.FILE_SIZE_LIMIT + " megabyte(s).", 302);
        }
    }

    public void validateProviderParams(String providerAccount, String providerApplication) {
        if (providerAccount == null && providerApplication == null) {
            return;
        }
        if (providerAccount == null || providerAccount.trim().isEmpty()) {
            DumpHelper.paramError("The parameter --provider-account is invalid.", 400);
        }
        if (providerApplication == null || providerApplication.trim().isEmpty()) {
            DumpHelper.paramError("The parameter --provider-application is invalid.", 400);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnectivity(String value) throws CommandException {
        File file = new File(value);
        String fileExtension = this.getFileExtension(file);
        if (fileExtension != null && !ALLOWED_EXTENSIONS.contains(fileExtension)) {
            this.LOGGER.debug("The specified configuration file " + value + " does not have an allowed extension.");
            DumpHelper.error("The parameter --localpath is invalid.The provided file [" + value + "] " + "does not have an allowed extension. Allowed extensions are: " + ALLOWED_EXTENSIONS.toString() + "." + "Files with no extension are also allowed.", 303);
        }
        if (!this.isKeyStoreExtension(fileExtension)) {
            Properties destinationProperties = new Properties();
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), CHARACTER_ENCODING);
                destinationProperties.load(reader);
                if (!destinationProperties.containsKey("Name") || !destinationProperties.containsKey("Type")) {
                    DumpHelper.error("The parameter --localpath is invalid.The provided file [" + value + "] " + "does not contain required properties for a destination file. Destination files should always have properties: " + "Name" + " and " + "Type" + ".", 304);
                }
                if (!this.keyStoreLocationValidator.validate(destinationProperties)) {
                    DumpHelper.error(String.format(KEYSTORE_LOCATION_ERROR_MESSAGE, value, "KeyStoreLocation", KeyStoreLocationValidator.ALLOWED_EXTENSIONS), 304);
                }
                if (!this.trustStoreLocationValidator.proceedValidation(destinationProperties)) {
                    DumpHelper.error(String.format(KEYSTORE_LOCATION_ERROR_MESSAGE, value, "TrustStoreLocation", TrustStoreLocationValidator.ALLOWED_EXTENSIONS), 304);
                }
            }
            catch (IOException e) {
                DumpHelper.error("The parameter --localpath is invalid.The provided file [" + value + "] " + "could not be loaded as a properties file, due to: " + e.getMessage() + ".", 305);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        this.LOGGER.debug("Could not close a reader to the properties file: ", e);
                    }
                }
            }
        }
    }

    private String getFileExtension(File file) {
        String fileExtension = null;
        String fileName = file.getName();
        int fileExtensionPosition = fileName.lastIndexOf(".");
        if (fileExtensionPosition != -1) {
            fileExtension = fileName.substring(fileExtensionPosition + 1).toLowerCase();
        }
        return fileExtension;
    }

    private boolean isKeyStoreExtension(String extension) {
        return KeyStoreLocationValidator.ALLOWED_EXTENSIONS.contains(extension) || TrustStoreLocationValidator.ALLOWED_EXTENSIONS.contains(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDestinationName(File file) {
        String fileExtension = this.getFileExtension(file);
        if (!this.isKeyStoreExtension(fileExtension)) {
            Properties properties = new Properties();
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), CHARACTER_ENCODING);
                properties.load(reader);
                if (properties.containsKey("Name")) {
                    String string = properties.getProperty("Name");
                    return string;
                }
            }
            catch (IOException e) {
                DumpHelper.error("The parameter --localpath is invalid.The provided file [" + file.getName() + "] " + "could not be loaded as a properties file, due to: " + e.getMessage() + ".", 305);
            }
            catch (IllegalArgumentException iae) {
                String message = String.format("The provided file [%s] is not valid properties file", file.getName());
                DumpHelper.error("The parameter --localpath is invalid." + message, 305);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        this.LOGGER.debug("Could not close a reader to the properties file: ", e);
                    }
                }
            }
        }
        return "";
    }

    static {
        HashSet<String> allowedExtensions = new HashSet<String>();
        Collections.addAll(allowedExtensions, "props", "properties", "txt");
        allowedExtensions.addAll(KeyStoreLocationValidator.ALLOWED_EXTENSIONS);
        allowedExtensions.addAll(TrustStoreLocationValidator.ALLOWED_EXTENSIONS);
        ALLOWED_EXTENSIONS = Collections.unmodifiableSet(allowedExtensions);
    }
}

