/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.config.cmd.validator;

import com.sap.core.connectivity.config.cmd.validator.Validator;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Set;

public class FilePathValidator
extends Validator {
    private String propertyKey;
    private Set<String> customAllowedExtensions;

    public FilePathValidator(String propertyName, Set<String> customAllowedExtensions) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Cannot validate properties. The property name passed to validator is null.");
        }
        if (customAllowedExtensions == null || customAllowedExtensions.isEmpty()) {
            throw new IllegalArgumentException("Cannot validate properties. The allowed extensions passed to validator missing.");
        }
        this.propertyKey = propertyName.trim();
        this.customAllowedExtensions = customAllowedExtensions;
    }

    @Override
    public boolean proceedValidation(Properties properties) {
        if (properties.containsKey(this.propertyKey)) {
            String value = properties.getProperty(this.propertyKey).trim();
            try {
                if (value.matches("[ ]*")) {
                    throw new URISyntaxException(value, "Input cannot be empty");
                }
                new URI(value);
                File file = new File(value);
                String extension = null;
                int fileExtensionPosition = file.getName().lastIndexOf(".");
                if (fileExtensionPosition != -1) {
                    extension = file.getName().substring(fileExtensionPosition + 1);
                }
                if (extension == null || !this.customAllowedExtensions.contains(extension.toLowerCase())) {
                    return false;
                }
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return true;
    }
}

