/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.naming.AuthenticationException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.DatatypeConverter;
import org.apache.openejb.client.ClientRuntimeException;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionFactory;
import org.apache.openejb.client.MulticastConnectionFactory;
import org.apache.openejb.client.SSLContextBuilder;

public class HttpConnectionFactory
implements ConnectionFactory {
    private final ConcurrentMap<URI, SSLSocketFactory> socketFactoryMap = new ConcurrentHashMap<URI, SSLSocketFactory>();
    private final Queue<byte[]> drainBuffers = new ConcurrentLinkedQueue<byte[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(URI uri) throws IOException {
        byte[] buffer = this.drainBuffers.poll();
        if (buffer == null) {
            buffer = new byte[Integer.getInteger("openejb.client.http.drain-buffer.size", 64).intValue()];
        }
        try {
            HttpConnection httpConnection = new HttpConnection(uri, this.socketFactoryMap, buffer);
            return httpConnection;
        }
        finally {
            this.drainBuffers.add(buffer);
        }
    }

    public static class HttpConnection
    implements Connection {
        private final byte[] buffer;
        private HttpURLConnection httpURLConnection;
        private InputStream inputStream;
        private OutputStream outputStream;
        private final URI uri;

        public HttpConnection(URI uri, ConcurrentMap<URI, SSLSocketFactory> socketFactoryMap, byte[] buffer) throws IOException {
            Map<String, String> params;
            this.uri = uri;
            this.buffer = buffer;
            URL url = uri.toURL();
            try {
                params = MulticastConnectionFactory.URIs.parseParamters(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid uri " + uri.toString(), e);
            }
            String basicUsername = params.get("basic.username");
            String basicPassword = params.get("basic.password");
            String authorizationHeader = params.get("authorizationHeader");
            String authorization = params.get("authorization");
            if (authorization != null && basicUsername != null) {
                throw new IllegalArgumentException("You can't set basic.* properties AND authorization on the provider url");
            }
            if (authorization == null && basicUsername != null) {
                authorization = "Basic " + DatatypeConverter.printBase64Binary((byte[])(basicUsername + (basicPassword != null ? ":" + basicPassword : "")).getBytes(StandardCharsets.UTF_8));
            }
            String newUrl = this.stripQuery(this.stripQuery(this.stripQuery(this.stripQuery(url.toExternalForm(), "authorization"), "basic.username"), "basic.password"), "authorizationHeader");
            this.httpURLConnection = (HttpURLConnection)(authorization == null ? url : new URL(newUrl)).openConnection();
            this.httpURLConnection.setDoOutput(true);
            int timeout = params.containsKey("connectTimeout") ? Integer.parseInt(params.get("connectTimeout")) : 10000;
            this.httpURLConnection.setConnectTimeout(timeout);
            if (params.containsKey("readTimeout")) {
                this.httpURLConnection.setReadTimeout(Integer.parseInt(params.get("readTimeout")));
            }
            if (authorization != null) {
                this.httpURLConnection.setRequestProperty(authorizationHeader == null ? "Authorization" : authorizationHeader, authorization);
            }
            if (params.containsKey("sslKeyStore") || params.containsKey("sslTrustStore")) {
                try {
                    SSLSocketFactory existing;
                    SSLSocketFactory sslSocketFactory = (SSLSocketFactory)socketFactoryMap.get(uri);
                    if (sslSocketFactory == null && (existing = socketFactoryMap.putIfAbsent(uri, sslSocketFactory = new SSLContextBuilder(params).build().getSocketFactory())) != null) {
                        sslSocketFactory = existing;
                    }
                    ((HttpsURLConnection)this.httpURLConnection).setSSLSocketFactory(sslSocketFactory);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new ClientRuntimeException(e.getMessage(), e);
                }
            }
            try {
                this.httpURLConnection.connect();
            }
            catch (IOException e) {
                this.httpURLConnection.connect();
            }
        }

        private String stripQuery(String url, String param) {
            String result = url;
            while (true) {
                int h;
                int end;
                if ((end = result.indexOf(38, h = result.indexOf(param + '='))) < 0) {
                    end = result.length();
                }
                if (h <= 0) {
                    return result.endsWith("?") ? result.substring(0, result.length() - 1) : result;
                }
                result = result.substring(0, h) + (end < 0 || end == result.length() ? "" : result.substring(end + 1, result.length()));
            }
        }

        @Override
        public void discard() {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public void close() throws IOException {
            IOException exception;
            block10: {
                exception = null;
                if (this.inputStream != null) {
                    try {
                        while (this.inputStream.read(this.buffer) > -1) {
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                }
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        if (exception != null) break block10;
                        exception = e;
                    }
                }
            }
            this.inputStream = null;
            this.outputStream = null;
            this.httpURLConnection = null;
            if (exception != null) {
                throw exception;
            }
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = this.httpURLConnection.getOutputStream();
            }
            return this.outputStream;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.inputStream == null) {
                if (this.httpURLConnection.getResponseCode() == 401) {
                    throw new IOException(new AuthenticationException());
                }
                this.inputStream = this.httpURLConnection.getInputStream();
            }
            return this.inputStream;
        }
    }
}

