/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.provider.neo.local;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.security.InvalidParameterException;

public class JsonUtils {
    private static JsonUtils instance;

    public static JsonUtils getInstance() {
        if (instance == null) {
            instance = new JsonUtils();
        }
        return instance;
    }

    public JsonObject parseJSONText(String jsonText) throws JsonSyntaxException, InvalidParameterException {
        if (jsonText == null) {
            this.throwInvalidParameterException("JSON Text is null or empty.");
        }
        if (jsonText.trim().equals("")) {
            return new JsonObject();
        }
        JsonParser parser = new JsonParser();
        JsonElement parsedElement = parser.parse(jsonText);
        if (parsedElement instanceof JsonNull) {
            throw new JsonSyntaxException("Parsed JSON Text is malformed.");
        }
        JsonObject parsedText = (JsonObject)parsedElement;
        return parsedText;
    }

    private void throwInvalidParameterException(String text) {
        throw new InvalidParameterException(text);
    }
}

