/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.provider.neo.local;

import com.sap.core.jpaas.security.utils.FileUtils;
import com.sap.security.um.provider.neo.local.group.persistence.GroupPersistenceManager;
import com.sap.security.um.provider.neo.local.user.persistence.UserPersistenceManager;
import com.sap.security.um.role.RoleProvider;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.ext.UserEx;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RoleProviderImpl
implements RoleProvider {
    public static final String USER_ROLE_EVERYONE = "Everyone";
    private static final String NEO_USERS_FILE = String.valueOf(System.getProperty("server.config.home", ".")) + File.separator + "config_master" + File.separator + "com.sap.security.um.provider.neo.local" + File.separator + "neousers.json";
    private static final String NEO_GROUPS_FILE = String.valueOf(System.getProperty("server.config.home", ".")) + File.separator + "config_master" + File.separator + "com.sap.security.um.provider.neo.local" + File.separator + "neogroups.json";
    private UserPersistenceManager userPersistenceManager;
    private GroupPersistenceManager groupPersistenceManager;

    public RoleProviderImpl() {
    }

    RoleProviderImpl(File usersFile, File groupsFile) {
        this.userPersistenceManager = new UserPersistenceManager(usersFile);
        this.groupPersistenceManager = new GroupPersistenceManager(groupsFile);
    }

    public void activate() throws IOException {
        File usersFile = FileUtils.getOrCreateJsonFile((String)NEO_USERS_FILE);
        this.userPersistenceManager = new UserPersistenceManager(usersFile);
        File groupsFile = FileUtils.getOrCreateJsonFile((String)NEO_GROUPS_FILE);
        this.groupPersistenceManager = new GroupPersistenceManager(groupsFile);
    }

    public String getIdentifier() {
        return "LOCAL";
    }

    public Set<String> getRoles(UserEx user) throws PersistenceException {
        if (this.userPersistenceManager == null || this.groupPersistenceManager == null) {
            try {
                this.activate();
            }
            catch (IOException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        Set<String> userRoles = this.userPersistenceManager.getRoles(user.getName());
        HashSet<String> groupNames = new HashSet<String>();
        groupNames.add("EVERYONE");
        Set userGroups = user.getGroups();
        if (userGroups != null) {
            groupNames.addAll(userGroups);
        }
        Set<String> groupRoles = this.groupPersistenceManager.getRoles(groupNames);
        HashSet<String> result = new HashSet<String>();
        if (userRoles != null) {
            result.addAll(userRoles);
        }
        if (groupRoles != null) {
            result.addAll(groupRoles);
        }
        Iterator it = result.iterator();
        while (it.hasNext()) {
            String role = (String)it.next();
            if (!role.equalsIgnoreCase(USER_ROLE_EVERYONE)) continue;
            it.remove();
        }
        result.add(USER_ROLE_EVERYONE);
        return result;
    }

    public Set<String> getRoles(UserEx user, Map<String, String> configuration) throws PersistenceException {
        return this.getRoles(user);
    }

    public String toString() {
        return "RoleProviderImpl [getIdentifier()=" + this.getIdentifier() + "]";
    }
}

