/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.provider.neo.local;

import com.sap.core.jpaas.security.utils.PasswordHash;
import com.sap.security.um.provider.neo.local.user.persistence.PersistenceUserImpl;
import com.sap.security.um.service.api.RoleManagementAccessor;
import com.sap.security.um.user.PasswordCheckResult;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.ext.UserEx;
import com.sap.security.um.user.modify.ModifiableUserEx;
import com.sap.security.um.user.modify.PasswordSetResult;
import com.sap.security.um.user.modify.ReadonlyAttributeException;
import com.sap.security.um.user.modify.UnsupportedLocaleException;
import com.sap.security.um.user.modify.UnsupportedUserAttributeValueException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserImpl
implements ModifiableUserEx {
    private String name;
    private Set<String> roles;
    private Set<String> groups;
    private HashMap<String, String[]> attributes;
    private boolean rolesInitialized;
    private String passwordHash;
    private int failedPasswordChecks;
    public static final String USER_GROUP_EVERYONE = "EVERYONE";
    public static final String USER_ROLE_EVERYONE = "Everyone";
    private static Logger logger = Logger.getLogger((String)"com.sap.security.um.provider.neo.local");

    public UserImpl(String name) {
        this.name = name;
        this.attributes = new HashMap();
        this.rolesInitialized = false;
    }

    public UserImpl(PersistenceUserImpl persistenceUser) {
        this.name = persistenceUser.getName();
        this.attributes = new HashMap();
        HashMap<String, String[]> pAttr = persistenceUser.getAttributes();
        if (pAttr != null) {
            this.attributes.putAll(pAttr);
        }
        this.passwordHash = persistenceUser.getPasswordHash();
        this.rolesInitialized = false;
    }

    public String getName() {
        return this.name;
    }

    public PasswordCheckResult checkPassword(char[] password) throws PersistenceException {
        if (this.passwordHash != null) {
            PasswordHash pwdHash = new PasswordHash(password);
            try {
                if (!pwdHash.checkHash(this.passwordHash)) {
                    logger.info((Object)"[Authentication & Authorization] Provided password does not match the one written into neousers.json file.");
                    if (this.failedPasswordChecks < Integer.MAX_VALUE) {
                        ++this.failedPasswordChecks;
                    }
                    return PasswordCheckResult.PWD_WRONG;
                }
                return PasswordCheckResult.PWD_OK;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot execute password check.", e);
            }
        }
        return PasswordCheckResult.PWD_DISABLED;
    }

    public String getAttribute(String attributeName) throws UnsupportedUserAttributeException {
        if (attributeName == null || attributeName.equals("")) {
            throw new UnsupportedUserAttributeException("Empty or null user attributes are not supported");
        }
        String[] attrValue = this.attributes.get(attributeName);
        return attrValue != null && attrValue.length > 0 ? attrValue[0] : null;
    }

    public Set<String> listAttributes() {
        HashSet<String> result = new HashSet<String>();
        Set<String> attrList = this.attributes.keySet();
        if (attrList != null) {
            result.addAll(attrList);
        }
        return result;
    }

    public Locale getLocale() {
        return Locale.US;
    }

    public boolean hasRole(String roleName) {
        if (roleName.equalsIgnoreCase(USER_ROLE_EVERYONE)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("User " + this.name + " has role Everyone"));
            }
            return true;
        }
        if (!this.rolesInitialized) {
            this.initializeRoles();
        }
        if (this.roles != null) {
            return this.roles.contains(roleName);
        }
        return false;
    }

    public boolean isValid(Calendar date) {
        return true;
    }

    public Set<String> getRoles() {
        if (!this.rolesInitialized) {
            this.initializeRoles();
        }
        HashSet<String> result = new HashSet<String>();
        if (this.roles != null) {
            result.addAll(this.roles);
        }
        return result;
    }

    private synchronized void initializeRoles() {
        if (!this.rolesInitialized) {
            try {
                this.roles = null;
                Set providedRoles = RoleManagementAccessor.getInstance().getRoleProvider().getRoles((UserEx)this);
                if (providedRoles != null) {
                    this.roles = new HashSet<String>();
                    this.roles.addAll(providedRoles);
                }
                this.rolesInitialized = true;
            }
            catch (PersistenceException persistenceException) {
                logger.error((Object)"Couldn't initialize roles");
            }
        }
    }

    public void assignRole(String roleName) {
        if (!this.rolesInitialized) {
            this.initializeRoles();
        }
        if (this.roles == null) {
            this.roles = new HashSet<String>();
        }
        this.roles.add(roleName);
    }

    public void removeRole(String roleName) {
        if (this.roles != null) {
            this.roles.remove(roleName);
        }
    }

    public void setAttribute(String attributeName, String value) throws UnsupportedUserAttributeException, UnsupportedUserAttributeValueException, ReadonlyAttributeException {
        if (attributeName == null || attributeName.equals("")) {
            throw new UnsupportedUserAttributeException("Empty or null user attribute names are not supported");
        }
        this.attributes.put(attributeName, new String[]{value});
    }

    public void setLocale(Locale locale) throws UnsupportedLocaleException, ReadonlyAttributeException {
        throw new UnsupportedOperationException();
    }

    public PasswordSetResult setPassword(char[] initialPassword) {
        throw new UnsupportedOperationException();
    }

    public PasswordSetResult setPassword(char[] currentPassword, char[] newPassword) {
        throw new UnsupportedOperationException();
    }

    public void setValidity(Calendar notBefore, Calendar notOnOrAfter) throws IllegalArgumentException, ReadonlyAttributeException {
        throw new UnsupportedOperationException();
    }

    public void setX509Certificate(X509Certificate certificate) throws ReadonlyAttributeException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "UserImpl [name=" + this.name + ", roles=" + this.roles + ", groups=" + this.groups + ", attributes=" + this.attributes + "]";
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public String[] getAttributeValues(String attributeName) {
        String[] attrValue = this.attributes.get(attributeName);
        if (attrValue != null) {
            String[] result = new String[attrValue.length];
            System.arraycopy(attrValue, 0, result, 0, attrValue.length);
            return result;
        }
        return null;
    }

    public Set<String> getGroups() {
        HashSet<String> result = new HashSet<String>();
        if (this.groups != null) {
            result.addAll(this.groups);
        }
        return result;
    }

    public void setAttributeValues(String attributeName, String[] values) throws UnsupportedUserAttributeException, UnsupportedUserAttributeValueException, ReadonlyAttributeException {
        String[] valuesCopy = null;
        if (values != null) {
            valuesCopy = new String[values.length];
            System.arraycopy(values, 0, valuesCopy, 0, values.length);
        }
        this.attributes.put(attributeName, valuesCopy);
    }

    public void setGroups(Set<String> groups) {
        this.groups = null;
        if (groups != null) {
            this.groups = new HashSet<String>();
            this.groups.addAll(groups);
        }
    }
}

