/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.provider.neo.local;

import com.sap.core.jpaas.security.utils.FileUtils;
import com.sap.security.um.provider.neo.local.UserImpl;
import com.sap.security.um.provider.neo.local.user.persistence.PersistenceUserImpl;
import com.sap.security.um.provider.neo.local.user.persistence.UserPersistenceManager;
import com.sap.security.um.service.api.UserSessionAccessor;
import com.sap.security.um.user.PasswordCheckResult;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import com.sap.security.um.user.modify.ModifiableUser;
import com.sap.security.um.user.modify.ModifiableUserProvider;
import com.sap.security.um.user.modify.UnsupportedUserNameException;
import com.sap.security.um.user.modify.UserAlreadyExistsException;
import java.io.File;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserProviderImpl
implements UserProvider,
ModifiableUserProvider {
    private static final String NEO_USERS_FILE = String.valueOf(System.getProperty("server.config.home", ".")) + File.separator + "config_master" + File.separator + "com.sap.security.um.provider.neo.local" + File.separator + "neousers.json";
    private UserPersistenceManager userPersistenceManager;
    private static Logger logger = Logger.getLogger((String)"com.sap.security.um.provider.neo.local");

    public UserProviderImpl() {
    }

    UserProviderImpl(File usersFile) {
        this.userPersistenceManager = new UserPersistenceManager(usersFile);
    }

    public void activate() {
        try {
            File usersFile = FileUtils.getOrCreateJsonFile((String)NEO_USERS_FILE);
            this.userPersistenceManager = new UserPersistenceManager(usersFile);
        }
        catch (IOException e) {
            logger.error((Object)("Cannot create file [" + NEO_USERS_FILE + "]: "), (Throwable)e);
        }
    }

    private UserPersistenceManager getUserPersistenceManager() {
        if (this.userPersistenceManager == null) {
            this.activate();
        }
        return this.userPersistenceManager;
    }

    public ModifiableUser createUser(String name) throws PersistenceException, UnsupportedUserNameException {
        if (name == null || name.startsWith(" ") || name.endsWith(" ") || name.indexOf(10) != -1) {
            throw new UnsupportedUserNameException("User name \"" + name + "\" contains leading spaces, trailing spaces, carriage return character or is null.");
        }
        Object user = this.getUser(name);
        if (user == null) {
            user = new UserImpl(name);
        }
        return (ModifiableUser)user;
    }

    public void deleteUser(String name) throws PersistenceException {
        this.deleteUserFromCache(name);
        this.getUserPersistenceManager().deleteUser(name);
    }

    public ModifiableUser getModifiableUser(String name) throws PersistenceException {
        return (ModifiableUser)this.getUser(name);
    }

    public void persistUser(ModifiableUser user) throws UserAlreadyExistsException, PersistenceException {
        try {
            PersistenceUserImpl currentPersistenceUser = this.getUserPersistenceManager().getUser(user.getName());
            Set<String> roles = null;
            if (currentPersistenceUser != null) {
                roles = currentPersistenceUser.getRoles();
            }
            PersistenceUserImpl persistenceUser = new PersistenceUserImpl((User)user, roles);
            this.getUserPersistenceManager().persistUser(persistenceUser);
            this.putUserIntoCache((User)user);
        }
        catch (UnsupportedUserAttributeException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public User getUser(String name) throws PersistenceException {
        Object user = null;
        PersistenceUserImpl persistenceUser = this.getUserPersistenceManager().getUser(name);
        if (persistenceUser != null && (user = this.getUserFromCache(name)) == null) {
            user = new UserImpl(persistenceUser);
        }
        return user;
    }

    public User getCurrentUser() throws PersistenceException {
        return this.getUserFromCache(null);
    }

    public User getUser(X509Certificate certificate) throws PersistenceException {
        return null;
    }

    public Set<String> searchUser(String attribute, String criteria, UserProvider.SearchOperator operator, UserProvider.CaseSensitive preferredCaseSensitivity) {
        Set<String> searchUser = this.getUserPersistenceManager().searchUser(attribute, criteria, operator, preferredCaseSensitivity);
        return searchUser;
    }

    public PasswordCheckResult checkUserPassword(String userName, char[] password) throws PersistenceException {
        User user = this.getUser(userName);
        if (user != null) {
            PasswordCheckResult checkPasswordResult = user.checkPassword(password);
            if (checkPasswordResult == PasswordCheckResult.PWD_OK) {
                this.putUserIntoCache(user);
                return null;
            }
            return checkPasswordResult;
        }
        if (logger.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[Authorization & Authentication] User with name: ");
            stringBuilder.append(userName);
            stringBuilder.append("[Authorization & Authentication] is not present into neousers.json file. Please check whether it exists trough server adapter's Users type or in the dir: <local_ljs>/config_master/com.sap.security.um.provider.neo.local/neousers.json. If edited by hand try to validate the file with some json validator");
            logger.info((Object)stringBuilder.toString());
        }
        return PasswordCheckResult.PWD_WRONG;
    }

    protected void setUserPersitenceManager(File file) {
        this.userPersistenceManager = new UserPersistenceManager(file);
    }

    private User getUserFromCache(String name) {
        UserSessionAccessor userCache = UserSessionAccessor.getSessionAccessor();
        if (userCache != null) {
            if (name == null) {
                return userCache.getCurrentUser();
            }
            return userCache.getUser(name);
        }
        this.logDebugMessage("UserCache is unavailable.");
        return null;
    }

    private void deleteUserFromCache(String name) {
        UserSessionAccessor userCache = UserSessionAccessor.getSessionAccessor();
        if (userCache != null) {
            userCache.deleteUser(name);
            this.logDebugMessage("User " + name + " was deleted from cache.");
        } else {
            this.logDebugMessage("UserCache is unavailable.");
        }
    }

    private void putUserIntoCache(User user) {
        UserSessionAccessor userCache = UserSessionAccessor.getSessionAccessor();
        if (userCache != null) {
            userCache.putUser(user);
            this.logDebugMessage("User " + user.getName() + " was added to cache.");
        } else {
            this.logDebugMessage("UserCache is unavailable.");
        }
    }

    private void logDebugMessage(String message) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)message);
        }
    }
}

