/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.provider.neo.local.group.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.sap.core.jpaas.security.utils.FileUtils;
import com.sap.security.um.provider.neo.local.JsonUtils;
import com.sap.security.um.provider.neo.local.group.persistence.GroupAlreadyExistsException;
import com.sap.security.um.provider.neo.local.group.persistence.GroupImpl;
import com.sap.security.um.user.PersistenceException;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GroupPersistenceManager {
    public static final String LOCATION = "com.sap.security.um.provider.neo.local";
    private static final String ROLES = "Roles";
    private static final String UID = "UID";
    private static final String GROUPS_NODE = "Groups";
    private static Logger logger = Logger.getLogger((String)"com.sap.security.um.provider.neo.local");
    private long groupFileLastModified;
    private File groupInfoFile;
    private String groupFileContents;
    private JsonObject parsedGroupsFile;
    private JsonUtils jsonUtils = JsonUtils.getInstance();

    public GroupPersistenceManager(File groupInfoFile) {
        this.groupInfoFile = groupInfoFile;
        this.groupFileContents = FileUtils.readFile((File)groupInfoFile);
        this.groupFileLastModified = groupInfoFile.lastModified();
        try {
            this.parsedGroupsFile = this.jsonUtils.parseJSONText(this.groupFileContents);
        }
        catch (JsonSyntaxException exc) {
            logger.error((Object)"[Authentication & Authorization] neogroups.json file is malformed. Try to edit the file trough server adapter's groups tab or manually by editing it in the dir: <local_ljs>/config_master/com.sap.security.um.provider.neo.local/neogroups.json. If edited by hand try to validate the file with some json validator.", (Throwable)exc);
            this.parsedGroupsFile = new JsonObject();
        }
    }

    public GroupImpl getGroup(String name) throws PersistenceException {
        GroupImpl foundGroup = this.findGroupByName(name);
        return foundGroup;
    }

    public void persistGroup(GroupImpl group) throws GroupAlreadyExistsException {
        this.updateExistingCacheWithNewGroup(group, this.parsedGroupsFile);
        Gson gsonFileContentsBuilder = new GsonBuilder().setPrettyPrinting().create();
        this.updateFile(gsonFileContentsBuilder);
    }

    public void deleteGroup(String name) throws PersistenceException {
        GroupImpl findGroupByName = this.findGroupByName(name);
        JsonObject parsedGroupsFileToReplace = new JsonObject();
        if (findGroupByName != null) {
            JsonElement jsonElement = this.parsedGroupsFile.get(GROUPS_NODE);
            JsonArray groupsArray = jsonElement.getAsJsonArray();
            JsonArray arrayWithoutDeletedGroup = new JsonArray();
            for (JsonElement groupElement : groupsArray) {
                JsonObject jsonGroupObject = groupElement.getAsJsonObject();
                String uid = jsonGroupObject.get(UID).getAsString();
                if (uid.equals(name)) continue;
                arrayWithoutDeletedGroup.add(groupElement);
            }
            parsedGroupsFileToReplace.add(GROUPS_NODE, (JsonElement)arrayWithoutDeletedGroup);
            this.parsedGroupsFile = parsedGroupsFileToReplace;
            Gson gsonFileContentsBuilder = new GsonBuilder().setPrettyPrinting().create();
            this.updateFile(gsonFileContentsBuilder);
        }
    }

    private void updateFile(Gson builder) {
        String jsonToWrite = builder.toJson((JsonElement)this.parsedGroupsFile);
        FileUtils.writeFile((File)this.groupInfoFile, (String)jsonToWrite);
    }

    private void updateExistingCacheWithNewGroup(GroupImpl group, JsonObject parsedCache) throws GroupAlreadyExistsException {
        if (this.findGroupByName(group.getName()) != null) {
            throw new GroupAlreadyExistsException("Group with name " + group.getName() + " already exists");
        }
        JsonObject jsonGroupToAdd = new JsonObject();
        jsonGroupToAdd.add(UID, (JsonElement)new JsonPrimitive(group.getName()));
        Set<String> rolesToAdd = group.getRoles();
        Gson create = new GsonBuilder().setPrettyPrinting().create();
        JsonElement rolesElement = create.toJsonTree(rolesToAdd);
        jsonGroupToAdd.add(ROLES, rolesElement);
        JsonArray jsonElement = (JsonArray)parsedCache.get(GROUPS_NODE);
        jsonElement.add((JsonElement)jsonGroupToAdd);
    }

    private GroupImpl findGroupByName(String groupName) {
        Set<GroupImpl> allGroups = this.getAllGroups();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[Authentication & Authorization] Now seraching for group with name " + groupName));
        }
        for (GroupImpl groupImpl : allGroups) {
            if (!groupImpl.getName().equalsIgnoreCase(groupName)) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[Authentication & Authorization] group found : " + groupImpl));
            }
            return groupImpl;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[Authentication & Authorization] Could not find group with name " + groupName + " The group is not available. Try to search the group via the server adapter groups tab or into file <local_ljs_home>/config_master/com.sap.security.um.provider.neo.local/neogroups.json"));
        }
        return null;
    }

    private Set<GroupImpl> getAllGroups() {
        this.refreshGroupFileContents(this.groupInfoFile);
        HashSet<GroupImpl> result = new HashSet<GroupImpl>();
        JsonElement jsonElement = this.parsedGroupsFile.get(GROUPS_NODE);
        if (jsonElement != null && jsonElement.isJsonArray()) {
            JsonArray asJsonArray = jsonElement.getAsJsonArray();
            for (JsonElement nextElement : asJsonArray) {
                GroupImpl convertedToGroup = this.convertToGroup(nextElement);
                if (convertedToGroup == null) continue;
                result.add(convertedToGroup);
            }
        }
        return result;
    }

    private void refreshGroupFileContents(File fileWithGroups) {
        if (this.isFileModified()) {
            this.groupFileContents = FileUtils.readFile((File)fileWithGroups);
            this.parsedGroupsFile = this.jsonUtils.parseJSONText(this.groupFileContents);
        }
    }

    private GroupImpl convertToGroup(JsonElement groupElement) {
        JsonObject jsonGroupObject = groupElement.getAsJsonObject();
        JsonElement jsonElement = jsonGroupObject.get(UID);
        String groupId = jsonElement.getAsString();
        GroupImpl groupToReturn = new GroupImpl(groupId);
        JsonElement roles = jsonGroupObject.get(ROLES);
        this.assignGroupRoles(roles, groupToReturn);
        return groupToReturn;
    }

    private void assignGroupRoles(JsonElement roles, GroupImpl group) {
        if (roles != null && roles.isJsonArray()) {
            JsonArray rolesArray = roles.getAsJsonArray();
            for (JsonElement nextRole : rolesArray) {
                String roleName = nextRole.getAsString();
                group.assignRole(roleName);
            }
        }
    }

    private boolean isFileModified() {
        boolean isFileModified = this.groupInfoFile.lastModified() > this.groupFileLastModified;
        this.groupFileLastModified = this.groupInfoFile.lastModified();
        return isFileModified;
    }

    public Set<String> getRoles(Set<String> groups) {
        if (groups == null) {
            return null;
        }
        Set<GroupImpl> allGroups = this.getAllGroups();
        HashSet<String> result = new HashSet<String>();
        for (GroupImpl group : allGroups) {
            if (!groups.contains(group.getName())) continue;
            result.addAll(group.getRoles());
        }
        return result;
    }
}

