/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.provider.neo.local.user.persistence;

import com.sap.security.um.provider.neo.local.UserImpl;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.modify.ReadonlyAttributeException;
import com.sap.security.um.user.modify.UnsupportedUserAttributeValueException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class PersistenceUserImpl {
    private String name;
    private Set<String> roles;
    private HashMap<String, String[]> attributes;
    private String passwordHash;

    public PersistenceUserImpl(String name) {
        this.name = name;
        this.attributes = new HashMap();
        this.roles = new HashSet<String>();
    }

    public PersistenceUserImpl(User user, Set<String> roles) throws UnsupportedUserAttributeException {
        this.name = user.getName();
        this.attributes = new HashMap();
        Set attributeNames = user.listAttributes();
        if (attributeNames != null) {
            for (String attrName : attributeNames) {
                String attrValue = user.getAttribute(attrName);
                this.attributes.put(attrName, new String[]{attrValue});
            }
        }
        this.roles = roles == null ? new HashSet() : roles;
        this.passwordHash = user instanceof UserImpl ? ((UserImpl)user).getPasswordHash() : null;
    }

    public String getName() {
        return this.name;
    }

    public String getAttribute(String attributeName) throws UnsupportedUserAttributeException {
        if (attributeName == null || attributeName.equals("")) {
            throw new UnsupportedUserAttributeException("Empty or null user attributes are not supported");
        }
        String[] attrValue = this.attributes.get(attributeName);
        return attrValue != null && attrValue.length > 0 ? attrValue[0] : null;
    }

    public Set<String> listAttributes() {
        return this.attributes.keySet();
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void assignRole(String roleName) {
        if (this.roles == null) {
            this.roles = new HashSet<String>();
        }
        this.roles.add(roleName);
    }

    public void removeRole(String roleName) {
        if (this.roles != null) {
            this.roles.remove(roleName);
        }
    }

    public void setAttribute(String attributeName, String value) throws UnsupportedUserAttributeException, UnsupportedUserAttributeValueException, ReadonlyAttributeException {
        if (attributeName == null || attributeName.equals("")) {
            throw new UnsupportedUserAttributeException("Empty or null user attribute names are not supported");
        }
        this.attributes.put(attributeName, new String[]{value});
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public HashMap<String, String[]> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "UserImpl [name=" + this.name + ", roles=" + this.roles + ", attributes=" + this.attributes + "]";
    }
}

