/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.provider.neo.local.user.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.sap.core.jpaas.security.utils.FileUtils;
import com.sap.security.um.UMException;
import com.sap.security.um.provider.neo.local.JsonUtils;
import com.sap.security.um.provider.neo.local.user.persistence.PersistenceUserImpl;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.UnsupportedUserAttributeException;
import com.sap.security.um.user.UserProvider;
import com.sap.security.um.user.modify.ReadonlyAttributeException;
import com.sap.security.um.user.modify.UnsupportedUserAttributeValueException;
import com.sap.security.um.user.modify.UserAlreadyExistsException;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserPersistenceManager {
    public static final String LOCATION = "com.sap.security.um.provider.neo.local";
    private static final String ATTRIBUTE_VALUE = "attributeValue";
    private static final String ATTRIBUTE_NAME = "attributeName";
    private static final String ATTRIBUTES = "Attributes";
    private static final String ROLES = "Roles";
    private static final String PASSWORD = "Password";
    private static final String UID = "UID";
    private static final String USERS_NODE = "Users";
    private static Logger logger = Logger.getLogger((String)"com.sap.security.um.provider.neo.local");
    private long userFileLastModified;
    private File userInfoFile;
    private String userFileContents;
    private JsonObject parsedUsersFile;
    private JsonUtils jsonUtils = JsonUtils.getInstance();

    public UserPersistenceManager(File userInfoFile) {
        this.userInfoFile = userInfoFile;
        this.userFileContents = FileUtils.readFile((File)userInfoFile);
        try {
            this.parsedUsersFile = this.jsonUtils.parseJSONText(this.userFileContents);
        }
        catch (JsonSyntaxException exc) {
            logger.error((Object)"[Authentication & Authorization] neousers.json file is malformed. Try to edit the file trough server adapter's Users tab or manually by editing it in the dir: <local_ljs>/config_master/com.sap.security.um.provider.neo.local/neousers.json. If edited by hand try to validate the file with some json validator.", (Throwable)exc);
            this.parsedUsersFile = new JsonObject();
        }
        this.userFileLastModified = userInfoFile.lastModified();
    }

    public PersistenceUserImpl getUser(String name) throws PersistenceException {
        try {
            PersistenceUserImpl foundUser = this.findUserByName(name);
            return foundUser;
        }
        catch (UMException exc) {
            throw new PersistenceException("Some user attributes are not supported", (Throwable)exc);
        }
    }

    public Set<String> searchUser(String attribute, String criteria, UserProvider.SearchOperator operator, UserProvider.CaseSensitive preferredCaseSensitivity) {
        try {
            return this.searchUserByAttribute(attribute, criteria, operator, preferredCaseSensitivity);
        }
        catch (UMException e) {
            logger.warn((Object)"Some user attributes are not supported ", (Throwable)e);
            return null;
        }
    }

    public void persistUser(PersistenceUserImpl user) throws UserAlreadyExistsException, PersistenceException {
        if (user.getPasswordHash() == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("User with name " + user.getName() + " won't be persisted into json file, because it has no password set"));
            }
            throw new PersistenceException("User with name " + user.getName() + " won't be persisted into json file, because it has no password set");
        }
        try {
            this.deleteUser(user.getName());
            this.updateExistingCacheWithNewUser(user, this.parsedUsersFile);
            Gson gsonFileContentsBuilder = new GsonBuilder().setPrettyPrinting().create();
            this.updateFile(gsonFileContentsBuilder);
        }
        catch (PersistenceException e) {
            logger.debug((Object)"User can't be updated", (Throwable)e);
        }
    }

    public void deleteUser(String name) throws PersistenceException {
        try {
            PersistenceUserImpl findUserByName = this.findUserByName(name);
            JsonObject parsedUsersFileToReplace = new JsonObject();
            if (findUserByName != null) {
                JsonElement jsonElement = this.parsedUsersFile.get(USERS_NODE);
                JsonArray usersArray = jsonElement.getAsJsonArray();
                JsonArray arrayWithoutDeletedUser = new JsonArray();
                for (JsonElement userElement : usersArray) {
                    JsonObject jsonUserObject = userElement.getAsJsonObject();
                    String uid = jsonUserObject.get(UID).getAsString();
                    if (uid.equals(name)) continue;
                    arrayWithoutDeletedUser.add(userElement);
                }
                parsedUsersFileToReplace.add(USERS_NODE, (JsonElement)arrayWithoutDeletedUser);
                this.parsedUsersFile = parsedUsersFileToReplace;
                Gson gsonFileContentsBuilder = new GsonBuilder().setPrettyPrinting().create();
                this.updateFile(gsonFileContentsBuilder);
            }
        }
        catch (UMException exc) {
            throw new PersistenceException("Some user attributes are not supported", (Throwable)exc);
        }
    }

    private void updateFile(Gson builder) {
        String jsonToWrite = builder.toJson((JsonElement)this.parsedUsersFile);
        FileUtils.writeFile((File)this.userInfoFile, (String)jsonToWrite);
    }

    private void updateExistingCacheWithNewUser(PersistenceUserImpl user, JsonObject parsedCache) throws PersistenceException {
        String userName = user.getName();
        JsonObject jsonUserToAdd = new JsonObject();
        jsonUserToAdd.add(UID, (JsonElement)new JsonPrimitive(userName));
        String passHash = user.getPasswordHash();
        jsonUserToAdd.add(PASSWORD, (JsonElement)new JsonPrimitive(passHash));
        Set<String> rolesToAdd = user.getRoles();
        Gson create = new GsonBuilder().setPrettyPrinting().create();
        JsonElement rolesElement = create.toJsonTree(rolesToAdd);
        jsonUserToAdd.add(ROLES, rolesElement);
        HashMap<String, String[]> attributesToAdd = user.getAttributes();
        Set<String> keySet = attributesToAdd.keySet();
        JsonArray arrayOfAttributes = new JsonArray();
        for (String key : keySet) {
            JsonObject attributeObject = new JsonObject();
            attributeObject.add(ATTRIBUTE_NAME, (JsonElement)new JsonPrimitive(key));
            attributeObject.add(ATTRIBUTE_VALUE, (JsonElement)new JsonPrimitive(attributesToAdd.get(key)[0]));
            arrayOfAttributes.add((JsonElement)attributeObject);
        }
        jsonUserToAdd.add(ATTRIBUTES, (JsonElement)arrayOfAttributes);
        JsonArray jsonElement = (JsonArray)parsedCache.get(USERS_NODE);
        jsonElement.add((JsonElement)jsonUserToAdd);
    }

    private Set<String> searchUserByAttribute(String attribute, String criteria, UserProvider.SearchOperator operator, UserProvider.CaseSensitive preferredCaseSensitivity) throws UnsupportedUserAttributeException, UnsupportedUserAttributeValueException, ReadonlyAttributeException {
        this.refreshUserFileContents(this.userInfoFile);
        Set<PersistenceUserImpl> allUsers = this.getAllUsers();
        HashSet<String> usersToReturn = new HashSet<String>();
        for (PersistenceUserImpl userImpl : allUsers) {
            String matcedhUserName = this.matchUserName(attribute, criteria, preferredCaseSensitivity, userImpl);
            if (matcedhUserName == null) continue;
            usersToReturn.add(matcedhUserName);
        }
        if (usersToReturn.size() == 0) {
            return null;
        }
        return usersToReturn;
    }

    private String matchUserName(String attribute, String criteria, UserProvider.CaseSensitive preferredCaseSensitivity, PersistenceUserImpl userImpl) throws UnsupportedUserAttributeException {
        String attributeValue = userImpl.getAttribute(attribute);
        if (attributeValue == null) {
            return null;
        }
        if (UserProvider.CaseSensitive.YES.equals((Object)preferredCaseSensitivity) ? attributeValue.equals(criteria) : attributeValue.equalsIgnoreCase(criteria)) {
            return userImpl.getName();
        }
        return null;
    }

    private PersistenceUserImpl findUserByName(String useraname) throws UnsupportedUserAttributeException, UnsupportedUserAttributeValueException, ReadonlyAttributeException {
        Set<PersistenceUserImpl> allUsers = this.getAllUsers();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[Authentication & Authorization] Now searching for user with name " + useraname));
        }
        for (PersistenceUserImpl userImpl : allUsers) {
            if (!userImpl.getName().equalsIgnoreCase(useraname)) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[Authentication & Authorization] user found : " + userImpl));
            }
            return userImpl;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[Authentication & Authorization] Could not find user with name " + useraname + " The user is not available. Try to search the user via the server adapter Users tab or into file <local_ljs_home>/config_master/com.sap.security.um.provider.neo.local/neousers.json"));
        }
        return null;
    }

    private Set<PersistenceUserImpl> getAllUsers() throws UnsupportedUserAttributeException, UnsupportedUserAttributeValueException, ReadonlyAttributeException {
        this.refreshUserFileContents(this.userInfoFile);
        HashSet<PersistenceUserImpl> result = new HashSet<PersistenceUserImpl>();
        JsonElement jsonElement = this.parsedUsersFile.get(USERS_NODE);
        if (jsonElement != null && jsonElement.isJsonArray()) {
            JsonArray asJsonArray = jsonElement.getAsJsonArray();
            for (JsonElement nextElement : asJsonArray) {
                PersistenceUserImpl convertedToUser = this.convertToUser(nextElement);
                if (convertedToUser == null) continue;
                result.add(convertedToUser);
            }
        }
        return result;
    }

    private void refreshUserFileContents(File fileWithUsers) {
        if (this.isFileModified()) {
            this.userFileContents = FileUtils.readFile((File)fileWithUsers);
            this.parsedUsersFile = this.jsonUtils.parseJSONText(this.userFileContents);
        }
    }

    private PersistenceUserImpl convertToUser(JsonElement userElement) throws UnsupportedUserAttributeException, UnsupportedUserAttributeValueException, ReadonlyAttributeException {
        JsonObject jsonUserObject = userElement.getAsJsonObject();
        JsonElement jsonElement = jsonUserObject.get(UID);
        String userId = jsonElement.getAsString();
        PersistenceUserImpl userToReturn = new PersistenceUserImpl(userId);
        String userPass = jsonUserObject.get(PASSWORD).getAsString();
        userToReturn.setPasswordHash(userPass);
        JsonElement roles = jsonUserObject.get(ROLES);
        this.assignUserRoles(roles, userToReturn);
        JsonElement attributes = jsonUserObject.get(ATTRIBUTES);
        this.assignUserAttributes(attributes, userToReturn);
        return userToReturn;
    }

    private void assignUserAttributes(JsonElement attributes, PersistenceUserImpl user) throws UnsupportedUserAttributeException, UnsupportedUserAttributeValueException, ReadonlyAttributeException {
        if (attributes.isJsonArray()) {
            JsonArray attributesArray = attributes.getAsJsonArray();
            for (JsonElement nextElement : attributesArray) {
                this.assignSingleAttribute(user, nextElement);
            }
        }
    }

    private void assignSingleAttribute(PersistenceUserImpl user, JsonElement nextElement) throws UnsupportedUserAttributeException, UnsupportedUserAttributeValueException, ReadonlyAttributeException {
        JsonObject attributeObject = nextElement.getAsJsonObject();
        JsonElement attributeNameElement = attributeObject.get(ATTRIBUTE_NAME);
        JsonElement attributeValueElement = attributeObject.get(ATTRIBUTE_VALUE);
        if (attributeNameElement != null && attributeValueElement != null) {
            String attributeName = attributeNameElement.getAsString();
            String attributeValue = attributeValueElement.getAsString();
            user.setAttribute(attributeName, attributeValue);
        }
    }

    private void assignUserRoles(JsonElement roles, PersistenceUserImpl user) {
        if (roles != null && roles.isJsonArray()) {
            JsonArray rolesArray = roles.getAsJsonArray();
            for (JsonElement nextRole : rolesArray) {
                String roleName = nextRole.getAsString();
                user.assignRole(roleName);
            }
        }
    }

    private boolean isFileModified() {
        boolean isFileModified = this.userInfoFile.lastModified() > this.userFileLastModified;
        this.userFileLastModified = this.userInfoFile.lastModified();
        return isFileModified;
    }

    public Set<String> getRoles(String userName) throws PersistenceException {
        try {
            PersistenceUserImpl user = this.findUserByName(userName);
            if (user != null) {
                return user.getRoles();
            }
            return null;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

