/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.api.auth;

import com.sap.ecm.api.internal.cert.ClientCertificate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.StandardAuthenticationProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.log4j.Logger;

public class EcmAuthenticationProvider
extends StandardAuthenticationProvider {
    private static final long serialVersionUID = -997822829893698075L;
    private static final Logger log = Logger.getLogger(EcmAuthenticationProvider.class);
    public static final String HTTPHEADER_X_ECMREPUNIQUENAME = "X-EcmRepUniqueNameEnc";
    public static final String HTTPHEADER_X_ECMREPKEY = "X-EcmRepKeyEnc";
    public static final String HTTPHEADER_X_ECM_USER = "X-EcmUserEnc";
    public static final String HTTPHEADER_X_ECM_ADDITIONAL_PRINCIPALS = "X-EcmAddPrincipals";
    public static final String HTTPHEADER_SAP_TENANT_ID = "SAP-Tenant-Id";
    private static final String HTTPHEADER_SAP_ECM_ENCRYPTION = "SAP-Ecm-Encryption";
    private SSLSocketFactory sslSocketFactory = null;

    public void setSession(BindingSession bindingSession) {
        String encryption;
        String tenantId;
        String user;
        String repKey;
        String additionalPrincipals;
        String uniqueName;
        super.setSession(bindingSession);
        Map fixedHeaders = this.getFixedHeaders();
        if (!fixedHeaders.containsKey(HTTPHEADER_X_ECMREPUNIQUENAME) && (uniqueName = (String)this.getSession().get(HTTPHEADER_X_ECMREPUNIQUENAME)) != null && !uniqueName.isEmpty()) {
            fixedHeaders.put(HTTPHEADER_X_ECMREPUNIQUENAME, Collections.singletonList(EcmAuthenticationProvider.encodeUTF8(uniqueName)));
        }
        if (!fixedHeaders.containsKey(HTTPHEADER_X_ECM_ADDITIONAL_PRINCIPALS) && (additionalPrincipals = (String)this.getSession().get(HTTPHEADER_X_ECM_ADDITIONAL_PRINCIPALS)) != null && !additionalPrincipals.isEmpty()) {
            fixedHeaders.put(HTTPHEADER_X_ECM_ADDITIONAL_PRINCIPALS, Collections.singletonList(EcmAuthenticationProvider.encodeUTF8(additionalPrincipals)));
        }
        if (!fixedHeaders.containsKey(HTTPHEADER_X_ECMREPKEY) && (repKey = (String)this.getSession().get(HTTPHEADER_X_ECMREPKEY)) != null && !repKey.isEmpty()) {
            fixedHeaders.put(HTTPHEADER_X_ECMREPKEY, Collections.singletonList(EcmAuthenticationProvider.encodeUTF8(repKey)));
        }
        if (!fixedHeaders.containsKey(HTTPHEADER_X_ECM_USER) && (user = (String)this.getSession().get(HTTPHEADER_X_ECM_USER)) != null && !user.isEmpty()) {
            fixedHeaders.put(HTTPHEADER_X_ECM_USER, Collections.singletonList(EcmAuthenticationProvider.encodeUTF8(user)));
        }
        if (!fixedHeaders.containsKey(HTTPHEADER_SAP_TENANT_ID) && (tenantId = (String)this.getSession().get(HTTPHEADER_SAP_TENANT_ID)) != null && !tenantId.isEmpty()) {
            fixedHeaders.put(HTTPHEADER_SAP_TENANT_ID, Collections.singletonList(tenantId));
        }
        if (!fixedHeaders.containsKey(HTTPHEADER_SAP_ECM_ENCRYPTION) && (encryption = (String)this.getSession().get(HTTPHEADER_SAP_ECM_ENCRYPTION)) != null && !encryption.isEmpty()) {
            fixedHeaders.put(HTTPHEADER_SAP_ECM_ENCRYPTION, Collections.singletonList(encryption));
        }
        ClientCertificate clientCertificate = new ClientCertificate();
        this.sslSocketFactory = clientCertificate.getSSLSocketFactory();
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public static String encodeUTF8(String message) {
        try {
            return URLEncoder.encode(message, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Could not encode input" + message), (Throwable)e);
            throw new CmisRuntimeException("Could not encode input" + message, (Throwable)e);
        }
    }
}

