/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.api.internal;

import com.sap.core.connectivity.api.DestinationFactory;
import com.sap.core.connectivity.api.DestinationNotFoundException;
import com.sap.core.connectivity.api.http.HttpDestination;
import com.sap.core.connectivity.httpdestination.common.HttpDestinationInfo;
import com.sap.core.connectivity.httpdestination.impl.HttpDestinationInfoDelegate;
import com.sap.ecm.api.internal.OSGiHelper;
import com.sap.ecm.api.internal.ServiceException;
import com.sap.ecm.api.internal.SessionLookup;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.log4j.Logger;

public class DestinationHelper {
    private static final Logger log = Logger.getLogger(DestinationHelper.class);
    private static DestinationFactory destinationFactory;
    private HttpDestination destination;
    private String actualDestinationName;
    private String specifiedDestinationName;

    static boolean isDestinationFactoryAvailable() {
        return DestinationHelper.getDestinationFactory() != null;
    }

    DestinationHelper(String actualDestinationName, String specifiedDestinationName) {
        this.actualDestinationName = actualDestinationName;
        this.specifiedDestinationName = specifiedDestinationName;
    }

    String extractURLFromDestination() {
        Class<?> cl = this.destination.getClass();
        String destUrl = null;
        try {
            Method m = cl.getMethod("getDestinationUrl", null);
            destUrl = (String)m.invoke((Object)this.destination, null);
            return destUrl;
        }
        catch (Exception e) {
            log.error((Object)"Could not obtain destination URL from destination object", (Throwable)e);
            return null;
        }
    }

    Properties getPropertiesFromDestination() {
        try {
            Field fieldx = this.destination.getClass().getDeclaredField("destinationInfoDelegate");
            fieldx.setAccessible(true);
            HttpDestinationInfoDelegate destinationInfoDelegate = (HttpDestinationInfoDelegate)fieldx.get(this.destination);
            HttpDestinationInfo destinationInfo = destinationInfoDelegate.getHttpDestinationInfo();
            Properties destinationProperties = destinationInfo.getProperties();
            return destinationProperties;
        }
        catch (Exception e) {
            log.error((Object)"Could not get properties from destination", (Throwable)e);
            throw new ServiceException("Could not get properties from destination", e);
        }
    }

    String getName() {
        if (this.getAndVerifyDestination() == null) {
            return "null(no destination)";
        }
        try {
            return this.destination.getName();
        }
        catch (Exception e) {
            log.error((Object)"Could not fetch name of destination", (Throwable)e);
            return "unknown(exc happened)";
        }
    }

    boolean verifyDestination() {
        return this.getAndVerifyDestination() != null;
    }

    private static DestinationFactory getDestinationFactory() {
        if (destinationFactory == null) {
            destinationFactory = OSGiHelper.get(DestinationFactory.class, SessionLookup.class);
        }
        return destinationFactory;
    }

    private HttpDestination getAndVerifyDestination() {
        if (this.destination == null) {
            HttpDestination dest;
            block8: {
                dest = null;
                try {
                    dest = (HttpDestination)DestinationHelper.getDestinationFactory().getDestination(this.actualDestinationName);
                    if (dest == null) break block8;
                    Class<?> cl = dest.getClass();
                    try {
                        Method m = cl.getMethod("getDestinationUrl", null);
                        m.invoke((Object)dest, null);
                    }
                    catch (Exception exception) {
                        log.info((Object)("Could not inspect destination '" + this.actualDestinationName + "'."));
                        return null;
                    }
                }
                catch (DestinationNotFoundException e) {
                    if (this.actualDestinationName.equals(this.specifiedDestinationName)) {
                        throw new CmisInvalidArgumentException("Specified destination " + this.specifiedDestinationName + " not found.", (Throwable)e);
                    }
                    log.info((Object)"Could not retrieve ecm destination. Fallback to localhost...", (Throwable)e);
                    return null;
                }
                catch (NullPointerException e) {
                    if (this.actualDestinationName.equals(this.specifiedDestinationName)) {
                        throw new CmisInvalidArgumentException("Specified destination " + this.specifiedDestinationName + " doesn't exist.", (Throwable)e);
                    }
                    log.info((Object)"Could not retrieve ecm destination (npe). Fallback to localhost...", (Throwable)e);
                    return null;
                }
            }
            this.destination = dest;
        }
        return this.destination;
    }
}

