/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.api.internal;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.tenant.common.TenantData;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.log4j.Logger;

public class LocalConfigurationServiceHelper {
    private static final Logger log = Logger.getLogger(LocalConfigurationServiceHelper.class);

    public static TenantData getTenantData() {
        try {
            Class<?> tenantClass = ClassloadingBridge.getImplClassLoader().loadClass("com.sap.core.tenant.api.Tenant");
            return (TenantData)ClassloadingBridge.invokeMethod(tenantClass, null, (String)"getData", null, null);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Properties getEcmUrlFromDestinationService(String actualDestinationName, String specifiedDestinationName) {
        Object propMap;
        block24: {
            Object result;
            Method method;
            block23: {
                Object connCfg;
                block22: {
                    block21: {
                        ServiceLoader<?> svcLoader;
                        block20: {
                            Class<?> clazz;
                            ClassLoader classLoader;
                            block19: {
                                block18: {
                                    connCfg = null;
                                    log.debug((Object)("getEcmUrlFromDestinationService called with actualDestinationName: " + actualDestinationName + ", specifiedDestinationName: " + specifiedDestinationName));
                                    classLoader = ClassloadingBridge.getImplClassLoader();
                                    if (classLoader != null) break block18;
                                    log.error((Object)"Failed to get ClassLoader from ClassloadingBridge");
                                    return null;
                                }
                                clazz = classLoader.loadClass("com.sap.core.connectivity.api.configuration.ConnectivityConfiguration");
                                if (clazz != null) break block19;
                                log.error((Object)"Failed to get class 'com.sap.core.connectivity.api.configuration.ConnectivityConfiguration' from ClassloadingBridge class loader");
                                return null;
                            }
                            svcLoader = ServiceLoader.load(clazz, classLoader);
                            if (svcLoader != null) break block20;
                            log.error((Object)"Failed to lookup com.sap.core.connectivity.api.configuration.ConnectivityConfiguration via ServiceLoader");
                            return null;
                        }
                        for (Object obj : svcLoader) {
                            log.debug((Object)("Found instance of ConnectivityConfiguration: " + obj.getClass().getName()));
                            try {
                                if (log.isDebugEnabled()) {
                                    LocalConfigurationServiceHelper.dumpMethods(obj);
                                }
                                obj.getClass().getMethod("getConfiguration", String.class);
                                log.debug((Object)"Found method getConfiguration");
                                connCfg = obj;
                                break;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        if (connCfg != null) break block21;
                        log.error((Object)"Failed to lookup com.sap.core.connectivity.api.configuration.ConnectivityConfiguration via ServiceLoader:");
                        return null;
                    }
                    method = connCfg.getClass().getMethod("getConfiguration", String.class);
                    if (method != null) break block22;
                    log.error((Object)("Could not find method: 'getConfiguration' in destination service, class was: " + connCfg.getClass().getName()));
                    return null;
                }
                result = method.invoke(connCfg, actualDestinationName);
                if (result != null) {
                    log.debug((Object)("Result of invoke: 'getConfiguration' in destination service is: " + result.getClass().getName()));
                }
                if (result != null) break block23;
                log.warn((Object)("Could not find destination: '" + actualDestinationName + "'"));
                if (actualDestinationName.equals(specifiedDestinationName)) {
                    throw new CmisInvalidArgumentException("Specified destination " + specifiedDestinationName + " not found.");
                }
                log.info((Object)"Could not retrieve ecm destination. Fallback to localhost...");
                return null;
            }
            if (log.isDebugEnabled()) {
                LocalConfigurationServiceHelper.dumpMethods(result);
            }
            if ((propMap = (method = result.getClass().getMethod("getAllProperties", new Class[0])).invoke(result, new Object[0])) != null) break block24;
            log.error((Object)"DestinationConfiguration result of getAllProperties() is null: ");
            return null;
        }
        try {
            if (propMap instanceof Map) {
                log.info((Object)("retrieved properties: " + propMap));
                return LocalConfigurationServiceHelper.copyMapToProperties((Map)propMap);
            }
            log.error((Object)("Unexpected class retrieved from destination service: " + propMap.getClass()));
        }
        catch (NoSuchMethodException ex) {
            log.error((Object)"Could not find method in destination service", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to call destination service via reflection", (Throwable)ex);
        }
        return null;
    }

    private static Properties copyMapToProperties(Map<String, String> map) {
        Properties result = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.setProperty(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static void dumpMethods(Object obj) {
        log.error((Object)"--->");
        LocalConfigurationServiceHelper.dumpMethods(obj.getClass());
        log.error((Object)"<---");
    }

    private static void dumpMethods(Class<?> clazz) {
        log.error((Object)("Methods of : " + clazz.getName()));
        Method[] m = clazz.getDeclaredMethods();
        int i = 0;
        while (i < m.length) {
            log.error((Object)("Found method in ConnectivityConfiguration: " + m[i].toString()));
            ++i;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            LocalConfigurationServiceHelper.dumpMethods(superClass);
        }
    }
}

