/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.api.internal;

import com.sap.core.tenant.common.TenantData;
import com.sap.ecm.api.internal.DestinationHelper;
import com.sap.ecm.api.internal.LocalConfigurationServiceHelper;
import com.sap.ecm.api.internal.ServiceException;
import com.sap.ecm.api.internal.TenantHelper;
import com.sap.ecm.api.internal.impl.LandscapeHelper;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.log4j.Logger;

public class SessionLookup {
    private static final int S2S_HTTP_PORT = 8443;
    private static final Logger log = Logger.getLogger(SessionLookup.class);
    private static final String ECM_SERVER_URL_SYSTEM_PROPERTY_NAME = "ecm.server.url";
    private static final boolean isOSGi = System.getProperty("osgi.install.area") != null;
    private static SessionFactory sessionFactory;
    private String specifiedDestinationName;
    private String actualDestinationName;
    private String ecmServerUrl;
    private String user;
    private String tenantId;

    public SessionLookup() {
        this(null, null, null);
    }

    public SessionLookup(String destinationName, String tenantId) {
        this(destinationName, tenantId, null);
    }

    public SessionLookup(String destinationName, String tenantId, String userId) {
        this.specifiedDestinationName = destinationName;
        this.actualDestinationName = this.specifiedDestinationName == null ? LandscapeHelper.getDefaultEcmDestinationName() : this.specifiedDestinationName;
        this.tenantId = tenantId;
        this.user = userId;
        this.computeEcmServerUrlAndUser();
    }

    public static SessionFactory getOpenCmisSessionFactory() {
        if (sessionFactory == null && (sessionFactory = SessionFactoryImpl.newInstance()) == null) {
            throw new ServiceException("Cannot instantiate OpenCmis SessionFactory.");
        }
        return sessionFactory;
    }

    private void computeEcmServerUrlAndUser() {
        String systemProp = System.getProperty(ECM_SERVER_URL_SYSTEM_PROPERTY_NAME);
        if (systemProp != null) {
            this.ecmServerUrl = this.addTenantSuffix(systemProp);
            log.info((Object)("Calculated ECM Server URL from system property is " + this.ecmServerUrl + "."));
            return;
        }
        Properties destinationProperties = null;
        String destUrl = null;
        String destinationName = null;
        if (isOSGi) {
            if (DestinationHelper.isDestinationFactoryAvailable()) {
                DestinationHelper currentDestinationHelper = new DestinationHelper(this.actualDestinationName, this.specifiedDestinationName);
                if (!currentDestinationHelper.verifyDestination()) {
                    log.info((Object)("Could not find/inspect destination with name " + this.actualDestinationName));
                } else {
                    destUrl = currentDestinationHelper.extractURLFromDestination();
                    destinationName = currentDestinationHelper.getName();
                    destinationProperties = currentDestinationHelper.getPropertiesFromDestination();
                }
            } else {
                log.error((Object)"DestinationService raised a NPE. Probably destination service bundles are not installed/started. Cannot use destination service and will fall back to localhost.");
            }
        } else {
            destinationProperties = LocalConfigurationServiceHelper.getEcmUrlFromDestinationService(this.actualDestinationName, this.specifiedDestinationName);
            if (destinationProperties != null) {
                destUrl = destinationProperties.getProperty("URL");
                destinationName = this.actualDestinationName;
            } else {
                log.info((Object)("Local configuration service cannot find destination properties for " + this.actualDestinationName + ". Cannot use destinations and will fall back to localhost."));
            }
        }
        if (destUrl != null && destinationProperties != null) {
            this.ecmServerUrl = this.computeDestinationURL(destUrl);
            this.ecmServerUrl = this.addTenantSuffix(this.ecmServerUrl);
            this.extractUser(destinationProperties);
            log.info((Object)("Computed user and calculated ECM Server URL from destination '" + destinationName + "' to " + this.ecmServerUrl + "."));
            return;
        }
        this.ecmServerUrl = LandscapeHelper.getEcmServerUrlLocalhostFallback();
        if (this.user == null) {
            try {
                this.user = this.getLoggedInUser();
            }
            catch (PersistenceException e) {
                log.error((Object)"Could not obtain logged in user", (Throwable)e);
            }
        }
        log.info((Object)("Fallbak ECM Server URL is " + this.ecmServerUrl + "."));
    }

    private String addTenantSuffix(String url) {
        String host;
        if (!LandscapeHelper.inCloud()) {
            return url;
        }
        TenantData tenantData = TenantHelper.getTenantData();
        if (tenantData == null) {
            String msg = "Tenant Service returned 'null' as current tenant - using the NW Cloud Document Service is not possible in a context without current tenant";
            CmisRuntimeException exc = new CmisRuntimeException(msg);
            log.error((Object)msg, (Throwable)exc);
            throw exc;
        }
        log.info((Object)("Tenant found: Id: " + tenantData.getId() + ", Name: " + tenantData.getName() + ", Alias: " + tenantData.getAlias()));
        int startIndex = url.indexOf("://") + 3;
        int endIndex = url.indexOf(".", startIndex);
        if (endIndex == -1 && (endIndex = url.indexOf(":", startIndex)) == -1) {
            endIndex = url.indexOf("/", startIndex);
        }
        if ((host = url.substring(startIndex, endIndex)).indexOf("-") == -1) {
            String newHost = String.valueOf(host) + "-" + tenantData.getAlias();
            String tenantUrl = url.replace(host, newHost);
            log.info((Object)("Computed ECM URL is: " + tenantUrl));
            if (this.tenantId == null) {
                this.tenantId = tenantData.getId();
            }
            return tenantUrl;
        }
        log.info((Object)("Tenant specific ECM URL in destination is: " + url));
        return url;
    }

    private String computeDestinationURL(String destUrl) {
        if (destUrl == null) {
            log.warn((Object)("Found ecm destination '" + this.actualDestinationName + "' but could not fetch URL attribute."));
        } else {
            log.info((Object)("Found ecm destination and parsed ecm server to be " + destUrl));
        }
        try {
            if (SessionLookup.urlContainsPort(destUrl)) {
                return destUrl;
            }
            URL orgUrl = new URL(destUrl);
            URL s2sUrl = new URL(orgUrl.getProtocol(), orgUrl.getHost(), 8443, orgUrl.getFile());
            return s2sUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new CmisInvalidArgumentException("Unable to parse URL " + destUrl + " ", (Throwable)e);
        }
    }

    private void extractUser(Properties destinationProperties) {
        if (this.user != null) {
            return;
        }
        String authType = destinationProperties.getProperty("Authentication");
        if (authType != null && authType.toLowerCase(Locale.ENGLISH).equals("basicauthentication")) {
            this.user = destinationProperties.getProperty("User");
        } else {
            try {
                this.user = this.getLoggedInUser();
            }
            catch (Exception e) {
                log.error((Object)"Could not compute logged in user)", (Throwable)e);
                throw new ServiceException("Could not compute logged in user", e);
            }
        }
    }

    private String getLoggedInUser() throws PersistenceException {
        try {
            UserProvider userProvider = UserManagementAccessor.getUserProvider();
            User currentUser = userProvider.getCurrentUser();
            return currentUser != null ? currentUser.getName() : null;
        }
        catch (NullPointerException e) {
            log.error((Object)"NPE in usermanagement", (Throwable)e);
            return null;
        }
    }

    public String getEcmServerUrl() {
        return this.ecmServerUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    private static boolean urlContainsPort(String url) {
        if (url != null) {
            int j;
            int i = url.indexOf("://");
            if ((i += 3) != -1 && (j = url.indexOf("/", i)) != -1) {
                return url.substring(i, j).indexOf(":") != -1;
            }
        }
        return false;
    }
}

