/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.accesslog;

import com.sap.cloud.runtime.tomcat.accesslog.EnhancedAccessLogValve;
import com.sap.cloud.runtime.tomcat.accesslog.util.IPAddressUtil;
import java.io.CharArrayWriter;
import java.util.Date;
import java.util.Enumeration;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.AbstractAccessLogValve;

public class AuthenticatedAccessLogValve
extends EnhancedAccessLogValve {
    static final String DEFAULT_ANONYMIZED_IP = "xxx";

    @Override
    protected AbstractAccessLogValve.AccessLogElement createXFFAccessLogElement(String name, char pattern) {
        return new XFFHeaderElement(name);
    }

    private static class XFFHeaderElement
    implements AbstractAccessLogValve.AccessLogElement {
        private final String header;

        public XFFHeaderElement(String header) {
            this.header = header;
        }

        public void addElement(CharArrayWriter buf, Date date, Request request, Response response, long time) {
            Enumeration iter = request.getHeaders(this.header);
            if (iter.hasMoreElements()) {
                buf.append(this.anonymizeIPIfNeeded((String)iter.nextElement(), request));
                while (iter.hasMoreElements()) {
                    buf.append(',').append((CharSequence)iter.nextElement());
                }
                return;
            }
            buf.append('-');
        }

        private String anonymizeIPIfNeeded(String ipAddress, Request request) {
            if (!this.isAuthenticated(request)) {
                return this.anonymizeIPAddress(ipAddress);
            }
            return ipAddress;
        }

        private boolean isAuthenticated(Request request) {
            return null != request && null != request.getUserPrincipal();
        }

        private String anonymizeIPAddress(String ipAddress) {
            IPAddressUtil anonymizer = new IPAddressUtil();
            try {
                return anonymizer.anonymizeIPAddress(ipAddress);
            }
            catch (IllegalArgumentException e) {
                return AuthenticatedAccessLogValve.DEFAULT_ANONYMIZED_IP;
            }
        }
    }
}

