/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.accesslog;

import com.sap.jdsr.writer.DsrIPassport;
import java.io.CharArrayWriter;
import java.util.Date;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.AbstractAccessLogValve;
import org.apache.catalina.valves.AccessLogValve;

public class EnhancedAccessLogValve
extends AccessLogValve {
    protected static final char PATTERN_CUSTOM_ACCESS_LOG_ELEMENT = 'Q';
    protected static final char PATERN_INCOMING_HEADER = 'i';
    protected static final String X_FORWARDED_FOR_HEADER_NAME = "X-Forwarded-For";
    protected static final String ATTR_PASSPORT = "passport";
    protected static final String ATTR_CORRELATION_ID = "corrid";
    protected static final char NO_ELEMENT = '-';

    protected AbstractAccessLogValve.AccessLogElement createAccessLogElement(String name, char pattern) {
        if (pattern == 'Q') {
            return this.createSapAccessLogElement(name);
        }
        if (pattern == 'i' && name.equals(X_FORWARDED_FOR_HEADER_NAME)) {
            return this.createXFFAccessLogElement(name, pattern);
        }
        return super.createAccessLogElement(name, pattern);
    }

    private AbstractAccessLogValve.AccessLogElement createSapAccessLogElement(String name) {
        if (null == name) {
            return new AbstractAccessLogValve.StringElement("???The access log element name cannot be null!???");
        }
        switch (name) {
            case "passport": {
                return new PassportAccessLogElement();
            }
            case "corrid": {
                return new CorrelationIdLogElement();
            }
        }
        return new AbstractAccessLogValve.StringElement("???Unsupported access log element name: " + name + "???");
    }

    protected AbstractAccessLogValve.AccessLogElement createXFFAccessLogElement(String name, char pattern) {
        return super.createAccessLogElement(name, pattern);
    }

    private static final class CorrelationIdLogElement
    implements AbstractAccessLogValve.AccessLogElement {
        private static final String NOTE_CORRELATION_ID = "x-correlation-id";

        private CorrelationIdLogElement() {
        }

        public void addElement(CharArrayWriter buf, Date date, Request request, Response response, long time) {
            Object note = request.getNote(NOTE_CORRELATION_ID);
            if (note instanceof String) {
                buf.append(note.toString());
            } else {
                buf.append('-');
            }
        }
    }

    private static final class PassportAccessLogElement
    implements AbstractAccessLogValve.AccessLogElement {
        private static final char SEPARATOR = '/';
        private static final char PASSPORT_START = '[';
        private static final char PASSPORT_END = ']';

        private PassportAccessLogElement() {
        }

        public void addElement(CharArrayWriter buf, Date date, Request request, Response response, long time) {
            Object note = request.getNote(DsrIPassport.class.getName());
            if (note instanceof DsrIPassport) {
                DsrIPassport passport = (DsrIPassport)note;
                buf.append('[');
                buf.append(passport.getTransId());
                buf.append('/');
                buf.append(passport.getConnectionIdHex());
                buf.append('/');
                buf.append(Integer.toString(passport.getConnectionCounter()));
                buf.append('/');
                buf.append(passport.getRootContextIdHex());
                buf.append(']');
            } else {
                buf.append('-');
            }
        }
    }
}

