/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.accesslog;

import com.sap.cloud.runtime.tomcat.accesslog.EnhancedAccessLogValve;
import java.io.CharArrayWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.AbstractAccessLogValve;

public class S2SAccessLogValve
extends EnhancedAccessLogValve {
    protected static final Set<String> ALLOWED_ATTRIBUTES;
    protected static final String ATTRIBUTE_CERT_PROPS = "clientProperties";

    public S2SAccessLogValve() {
        this.setPattern("%{yyyy-MM-dd'T'HH:mm:ss.SSSZ}t %{corrid}Q %{host}Q %{account}Q %{appliance}Q %{component}Q %{tenant}Q %I %l %u %r %s %b %D %{Host}i");
    }

    @Override
    protected AbstractAccessLogValve.AccessLogElement createAccessLogElement(String name, char pattern) {
        AbstractAccessLogValve.AccessLogElement accessLogElement = null;
        if (pattern == 'Q') {
            accessLogElement = this.createExtensionAccessLogElement(name);
        }
        if (null == accessLogElement) {
            accessLogElement = super.createAccessLogElement(name, pattern);
        }
        return accessLogElement;
    }

    private AbstractAccessLogValve.AccessLogElement createExtensionAccessLogElement(String name) {
        if (ALLOWED_ATTRIBUTES.contains(name)) {
            return new CertificateAttributeElement(name);
        }
        return null;
    }

    public void log(Request request, Response response, long time) {
        Object attachment = request.getAttribute(ATTRIBUTE_CERT_PROPS);
        if (attachment instanceof Map) {
            super.log(request, response, time);
        }
    }

    static {
        HashSet<String> attributes = new HashSet<String>();
        attributes.add("host");
        attributes.add("tenant");
        attributes.add("account");
        attributes.add("appliance");
        attributes.add("component");
        attributes.add("permissions");
        attributes.add("description");
        attributes.add("user");
        ALLOWED_ATTRIBUTES = Collections.unmodifiableSet(attributes);
    }

    private static final class CertificateAttributeElement
    implements AbstractAccessLogValve.AccessLogElement {
        private final String attribute;

        public CertificateAttributeElement(String attribute) {
            this.attribute = attribute;
        }

        public void addElement(CharArrayWriter buf, Date date, Request request, Response response, long time) {
            Map attributes = (Map)request.getAttribute(S2SAccessLogValve.ATTRIBUTE_CERT_PROPS);
            Object value = attributes.get(this.attribute);
            if (!(value instanceof String)) {
                buf.append('-');
                return;
            }
            buf.append(value.toString());
        }
    }
}

