/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.accesslog.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPAddressUtil {
    static final Pattern IPv4_PATTERN = Pattern.compile("(\\d{1,3})(\\.\\d{1,3}){3}$");
    static final Pattern IPv6_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    static final Pattern IPv6_COMPRESSED_PATTERN = Pattern.compile(".*::.*");
    static final Pattern IPv6_GROUP_PATTERN = Pattern.compile("(:[0-9a-fA-F]{1,4}|[0-9a-fA-F]{1,4}:|:[0-9a-fA-F]{1,4}:)");
    static final int IPv6_ADDRESS_GROUPS_COUNT = 8;
    static final String ANONYMIZING_CHARACTER = "x";
    static final char COLON = ':';
    static final String DOUBLE_COLON = "::";
    static final String ZERO = "0";
    static final String IPv6_ANONYMIZED_PART = "x:x:x:x:x";

    public String anonymizeIPAddress(String ip) throws IllegalArgumentException {
        if (this.isIPv4Address(ip)) {
            return this.anonymizeIPv4Address(ip);
        }
        if (this.isIPv6Address(ip)) {
            return this.anonymizeIPv6Address(ip);
        }
        if (this.isIPv6CompressedAddress(ip)) {
            return this.anonymizeIPv6CompressedAddress(ip);
        }
        throw new IllegalArgumentException(ip + " not an IP address");
    }

    boolean isIPv4Address(String ip) {
        return this.isMatch(ip, IPv4_PATTERN);
    }

    boolean isMatch(String input, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    String anonymizeIPv4Address(String ip) {
        int lastDotIndex = ip.lastIndexOf(".");
        StringBuilder builder = new StringBuilder(lastDotIndex + 2);
        builder.append(ip.substring(0, lastDotIndex + 1));
        builder.append(ANONYMIZING_CHARACTER);
        return builder.toString();
    }

    boolean isIPv6Address(String ip) {
        return this.isMatch(ip, IPv6_PATTERN);
    }

    String anonymizeIPv6Address(String ip) {
        int index = this.findOccurranceIn(ip, ':', 3);
        StringBuilder builder = new StringBuilder(index + 1 + IPv6_ANONYMIZED_PART.length());
        builder.append(ip.substring(0, index + 1));
        builder.append(IPv6_ANONYMIZED_PART);
        return builder.toString();
    }

    boolean isIPv6CompressedAddress(String ip) {
        return this.isMatch(ip, IPv6_COMPRESSED_PATTERN);
    }

    int findOccurranceIn(String str, char ch, int occurance) {
        int currentIndex = str.indexOf(ch);
        while (currentIndex > -1 && --occurance > 0) {
            currentIndex = str.indexOf(ch, currentIndex + 1);
        }
        return currentIndex;
    }

    String anonymizeIPv6CompressedAddress(String ip) {
        String decompressedIPv6Address = this.decompressIPv6Address(ip);
        String anonymizedIPv6Address = this.anonymizeIPv6Address(decompressedIPv6Address);
        return this.compressIPv6Address(anonymizedIPv6Address);
    }

    String decompressIPv6Address(String ip) {
        int nonZeroGroupsCount = this.findNonZeroGroupsCountInAddress(ip);
        int compressedZeroGroupsCount = 8 - nonZeroGroupsCount;
        StringBuilder builder = new StringBuilder();
        builder.append(ZERO);
        for (int i = 0; i < compressedZeroGroupsCount - 1; ++i) {
            builder.append(":0");
        }
        boolean isIPBeginningCompressed = ip.startsWith(DOUBLE_COLON);
        boolean isIPEndCompressed = ip.endsWith(DOUBLE_COLON);
        if (isIPBeginningCompressed && !isIPEndCompressed) {
            builder.append(':');
        } else if (isIPEndCompressed && !isIPBeginningCompressed) {
            builder.insert(0, ':');
        } else if (!isIPBeginningCompressed && !isIPEndCompressed) {
            builder.insert(0, ':').append(':');
        }
        String decompressedIPv6Address = ip.replace(DOUBLE_COLON, builder.toString());
        return decompressedIPv6Address;
    }

    int findNonZeroGroupsCountInAddress(String ip) {
        Matcher matcher = IPv6_GROUP_PATTERN.matcher(ip);
        return this.findNumberOfOccurrences(matcher);
    }

    int findNumberOfOccurrences(Matcher matcher) {
        int from = 0;
        int count = 0;
        while (matcher.find(from)) {
            ++count;
            from = matcher.end();
        }
        return count;
    }

    String compressIPv6Address(String ip) {
        if (ip.startsWith("0:0:0")) {
            return ip.replace("0:0:0", String.valueOf(':'));
        }
        if (ip.startsWith("0:0")) {
            return ip.replace("0:0", String.valueOf(':'));
        }
        if (ip.contains(":0:0")) {
            return ip.replace(":0:0", String.valueOf(':'));
        }
        return ip;
    }
}

