/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.common;

import com.sap.core.utils.destinations.validation.validators.CompositeValidator;
import com.sap.core.utils.destinations.validation.validators.common.KeyValueContentValidator;
import com.sap.core.utils.destinations.validation.validators.common.KeyValueEndValidator;
import com.sap.core.utils.destinations.validation.validators.common.KeyValueNotEmptyValidator;
import com.sap.core.utils.destinations.validation.validators.common.KeyValueStartValidator;
import com.sap.core.utils.destinations.validation.validators.common.KeyValueValueValidator;

public abstract class AbstractKeyValueCompositeValidator
extends CompositeValidator {
    protected boolean shouldCheckValue;
    private String startRegex;
    private String regex;
    private String optionalProperty;

    public AbstractKeyValueCompositeValidator(String startRegex, String regex, boolean shouldCheckValue, String optionalProperty) {
        this.startRegex = startRegex;
        this.regex = regex;
        this.shouldCheckValue = shouldCheckValue;
        this.optionalProperty = optionalProperty;
    }

    @Override
    protected void addSpecificValidators() {
        this.validators.add(new KeyValueNotEmptyValidator());
        this.validators.add(new KeyValueStartValidator(this.startRegex, this.getStartErrorMessage()));
        this.validators.add(new KeyValueContentValidator(this.regex, this.getContentErrorMessage()));
        this.validators.add(new KeyValueEndValidator());
        this.validators.add(new KeyValueValueValidator(this.shouldCheckValue, this.optionalProperty));
    }

    protected abstract String getStartErrorMessage();

    protected abstract String getContentErrorMessage();
}

