/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.common;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class BasicPropertiesValidator
extends Validator {
    private String key;
    private boolean isMandatory;
    private ViolationType violationIfMandatoryAndMissing;
    private boolean canBeEmpty;

    public BasicPropertiesValidator(String key, boolean isMandatory, ViolationType violaionTypeIfMandatoryAndMissing, boolean canBeEmpty) {
        this.key = key;
        this.isMandatory = isMandatory;
        this.violationIfMandatoryAndMissing = violaionTypeIfMandatoryAndMissing;
        this.canBeEmpty = canBeEmpty;
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        String value;
        ViolationSet violations = new ViolationSet();
        if (this.isMandatory && !properties.containsKey(this.key)) {
            violations.add(new Violation(this.violationIfMandatoryAndMissing, Messages.getMessage("PropertyMissing", this.key), Severity.ERROR));
        } else if (properties.containsKey(this.key) && !this.canBeEmpty && (value = properties.getProperty(this.key).trim()).isEmpty()) {
            violations.add(new Violation(ViolationType.EMPTY_STRING, Messages.getMessage("ValueIsEmptyString", this.key), Severity.ERROR));
        }
        return violations;
    }
}

