/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.common;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class BooleanValidator
extends Validator {
    private String propertyKey;
    private boolean isMandatory;

    public BooleanValidator(String propertyKey, boolean isMandatory) {
        if (propertyKey == null) {
            throw new IllegalArgumentException("Cannot validate properties. Argument passed to validator is null.");
        }
        this.propertyKey = propertyKey.trim();
        this.isMandatory = isMandatory;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        boolean propertyExists = properties.containsKey(this.propertyKey);
        if (this.isMandatory && !propertyExists) {
            violations.add(new Violation(ViolationType.MANDATORY_BOOLEAN_PROPERTY_MISSING, Messages.getMessage("PropertyMissing", this.propertyKey), Severity.ERROR));
            return violations;
        }
        if (propertyExists) {
            violations.addSet(this.checkBooleanValue(properties));
        }
        return violations;
    }

    private ViolationSet checkBooleanValue(Properties properties) {
        ViolationSet violations = new ViolationSet();
        String value = properties.getProperty(this.propertyKey).trim();
        if (!value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            violations.add(new Violation(ViolationType.VALUE_OF_BOOLEAN_PROPERTY_NOT_VALID, Messages.getMessage("BooleanPropertyNotValid", this.propertyKey, value), Severity.ERROR));
            return violations;
        }
        return violations;
    }
}

