/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.common;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.utils.CommonConstants;
import com.sap.core.utils.destinations.validation.utils.ValidValuesFormatter;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class DestinationProviderValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (!properties.containsKey("DestinationProvider")) {
            return violations;
        }
        String value = properties.getProperty("DestinationProvider").trim();
        if (!CommonConstants.allowedDestinationProviders.contains(value)) {
            violations.add(new Violation(ViolationType.DESTINATION_PROVIDER_NOT_VALID, Messages.getMessage("ValueIsNotInAllowedRange", value, "DestinationProvider", ValidValuesFormatter.format(CommonConstants.allowedDestinationProviders)), Severity.ERROR));
            return violations;
        }
        return violations;
    }
}

