/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.common;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class NameValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (!properties.containsKey("Name")) {
            violations.add(new Violation(ViolationType.NAME_MISSING, Messages.getMessage("MissingElementNameErrorMSG", new Object[0]), Severity.ERROR));
            return violations;
        }
        String value = properties.getProperty("Name").trim();
        if (properties.getProperty("Name").trim().isEmpty()) {
            violations.add(new Violation(ViolationType.EMPTY_NAME, Messages.getMessage("MissingDestinationName", new Object[0]), Severity.ERROR));
            return violations;
        }
        if (value.length() > 200) {
            violations.add(new Violation(ViolationType.NAME_TOO_LONG, Messages.getMessage("NameTooLong", "Name", 200), Severity.ERROR));
            return violations;
        }
        if (!value.matches("(([\\w-]+)|([\\w-]+(\\.(?i)(props|properties))$))")) {
            violations.add(new Violation(ViolationType.NAME_DOES_NOT_MATCH_REGEX, Messages.getMessage("NameDoesNotMatchRegEx", new Object[0]), Severity.ERROR));
            return violations;
        }
        return violations;
    }
}

