/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.common;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class TypeValidator
extends Validator {
    private String validType;

    public TypeValidator(String validType) {
        if (validType == null) {
            throw new IllegalArgumentException("Cannot validate properties. Argument passed to validator is null.");
        }
        this.validType = validType;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (!properties.containsKey("Type")) {
            violations.add(new Violation(ViolationType.TYPE_MISSING, Messages.getMessage("MissingElementTypeErrorMsg", new Object[0]), Severity.ERROR));
            return violations;
        }
        String value = properties.getProperty("Type").trim();
        if (value.isEmpty()) {
            violations.add(new Violation(ViolationType.EMPTY_TYPE, Messages.getMessage("MissingDestinationType", new Object[0]), Severity.ERROR));
            return violations;
        }
        if (!value.equals(this.validType)) {
            violations.add(new Violation(ViolationType.TYPE_NOT_VALID, Messages.getMessage("TypeNotValid", this.validType), Severity.ERROR));
            return violations;
        }
        return violations;
    }
}

