/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class AuthBasicValidator
extends Validator {
    private boolean canBeEmpty;
    private String propertyToCheck;
    private ViolationType propertyMissing;
    private ViolationType propertyNotValid;
    private ViolationType propertyRedundant;
    private static final Set<String> CertificationPropertiesSet = new HashSet<String>(Arrays.asList("KeyStoreLocation", "KeyStorePassword"));

    public AuthBasicValidator(String propertyKey, boolean canBeEmpty, ViolationType propertyMissing, ViolationType propertyNotValid, ViolationType propertyRedundant) {
        this.propertyToCheck = propertyKey;
        this.canBeEmpty = canBeEmpty;
        this.propertyMissing = propertyMissing;
        this.propertyNotValid = propertyNotValid;
        this.propertyRedundant = propertyRedundant;
    }

    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        boolean authPropertyExists = properties.containsKey(this.propertyToCheck);
        if (!properties.containsKey("Authentication") && authPropertyExists) {
            violations.add(new Violation(ViolationType.AUTHENTICATION_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "Authentication", this.propertyToCheck), Severity.WARNING));
            return violations;
        }
        if (properties.containsKey("Authentication")) {
            String authentication = properties.getProperty("Authentication").trim();
            if (authentication.equals("BasicAuthentication") && !CertificationPropertiesSet.contains(this.propertyToCheck)) {
                if (!authPropertyExists) {
                    violations.add(new Violation(this.propertyMissing, Messages.getMessage("MissingRequiredAuthenticationRelatedProperty", "BasicAuthentication", this.propertyToCheck), Severity.ERROR));
                    return violations;
                }
                if (authPropertyExists && !this.canBeEmpty && properties.getProperty(this.propertyToCheck).trim().isEmpty()) {
                    violations.add(new Violation(this.propertyNotValid, Messages.getMessage("ValueIsEmptyString", this.propertyToCheck), Severity.ERROR));
                    return violations;
                }
            } else if (authentication.equals("ClientCertificateAuthentication") && CertificationPropertiesSet.contains(this.propertyToCheck)) {
                if (!authPropertyExists) {
                    violations.add(new Violation(this.propertyMissing, Messages.getMessage("MissingRequiredAuthenticationRelatedProperty", "ClientCertificateAuthentication", this.propertyToCheck), Severity.ERROR));
                    return violations;
                }
                if (authPropertyExists && !this.canBeEmpty && properties.getProperty(this.propertyToCheck).trim().isEmpty()) {
                    violations.add(new Violation(this.propertyNotValid, Messages.getMessage("ValueIsEmptyString", this.propertyToCheck), Severity.ERROR));
                    return violations;
                }
            }
            if (!authentication.equals("BasicAuthentication") && !authentication.equals("ClientCertificateAuthentication") && authPropertyExists) {
                violations.add(new Violation(this.propertyRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", this.propertyToCheck, "Authentication", "BasicAuthentication"), Severity.WARNING));
                return violations;
            }
        }
        return violations;
    }
}

