/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.utils.CommonUtils;
import com.sap.core.utils.destinations.validation.utils.ValidValuesFormatter;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.common.BasicPropertiesValidator;
import com.sap.core.utils.destinations.validation.validators.http.consts.HttpConstants;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class AuthenticationValidator
extends Validator {
    private static Set<String> exceptionalCases = new HashSet<String>();
    private boolean initialCheck;

    static {
        Collections.addAll(exceptionalCases, "InternalSystemAuthentication", "OAuth2SAMLBearerAssertion");
    }

    public AuthenticationValidator(boolean initialCheck) {
        this.initialCheck = initialCheck;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        String value;
        BasicPropertiesValidator validator = new BasicPropertiesValidator("Authentication", true, ViolationType.AUTHENTICATION_MISSING, false);
        ViolationSet violations = validator.validate(properties);
        if (violations.hasErrors()) {
            return violations;
        }
        String string = value = properties.getProperty("Authentication") == null ? null : properties.getProperty("Authentication").trim();
        if (this.initialCheck) {
            if (!HttpConstants.allowedTypesOfAuthenticationFromIDE.contains(value)) {
                violations.add(new Violation(ViolationType.AUTHENTICATION_NOT_VALID, Messages.getMessage("NotSupportedAuthenticationTypeFromInitialCheck", new Object[0]), Severity.ERROR));
                return violations;
            }
        } else if (!HttpConstants.allowedTypesOfAuthentication.contains(value) && !exceptionalCases.contains(value)) {
            violations.add(new Violation(ViolationType.AUTHENTICATION_NOT_VALID, Messages.getMessage("ValueIsNotInAllowedRange", value, "Authentication", ValidValuesFormatter.format(HttpConstants.allowedTypesOfAuthentication)), Severity.ERROR));
            return violations;
        }
        violations.addSet(this.validateClientCertificateAuthenticationType(properties, value));
        if (violations.hasErrors() || violations.hasWarnings()) {
            return violations;
        }
        violations.addSet(this.validatePrincipalPropagation(properties, value));
        return violations;
    }

    private ViolationSet validateClientCertificateAuthenticationType(Properties properties, String value) {
        ViolationSet violations = new ViolationSet();
        if (value.equals("ClientCertificateAuthentication")) {
            String proxyType = properties.getProperty("ProxyType");
            if (proxyType != null && !proxyType.trim().equals("Internet")) {
                violations.add(new Violation(ViolationType.CLIENT_CERTIFICATE_AUTHENTICATION_INAPPROPRIATE, Messages.getMessage("AuthenticationNotValidInCombinationWith", value, "ProxyType", "Internet"), Severity.ERROR));
                return violations;
            }
            if (!CommonUtils.isSetNonEmptyProperty(properties, "URL")) {
                violations.add(new Violation(ViolationType.URL_MISSING, Messages.getMessage("UrlMissingNeededToCheckClientCertificateAuthentication", value), CommonUtils.getSeverityAccordingToClient(this.initialCheck)));
                return violations;
            }
            String url = properties.getProperty("URL").trim();
            if (!url.toLowerCase().startsWith("https")) {
                violations.add(new Violation(ViolationType.CLIENT_CERTIFICATE_AUTHENTICATION_INAPPROPRIATE, Messages.getMessage("UrlWithoutHttpsNeededToCheckClientCertificateAuthentication", new Object[0]), Severity.ERROR));
                return violations;
            }
        }
        return violations;
    }

    private ViolationSet validatePrincipalPropagation(Properties properties, String authValue) {
        boolean isCloudConnectorVersion2;
        boolean isOnPremise;
        ViolationSet violations = new ViolationSet();
        if (!authValue.equals("PrincipalPropagation")) {
            return violations;
        }
        boolean bl = isOnPremise = properties.containsKey("ProxyType") && properties.getProperty("ProxyType").trim().equals("OnPremise");
        if (!isOnPremise) {
            violations.add(new Violation(ViolationType.PRINCIPAL_PROPAGATION_INAPPROPRIATE, Messages.getMessage("AuthenticationNotValidInCombinationWith", authValue, "ProxyType", "OnPremise"), Severity.ERROR));
            return violations;
        }
        boolean bl2 = isCloudConnectorVersion2 = properties.containsKey("CloudConnectorVersion") && properties.getProperty("CloudConnectorVersion").trim().equals("2");
        if (!isCloudConnectorVersion2) {
            violations.add(new Violation(ViolationType.PRINCIPAL_PROPAGATION_INAPPROPRIATE, Messages.getMessage("AuthenticationNotValidInCombinationWith", authValue, "CloudConnectorVersion", "2"), Severity.ERROR));
            return violations;
        }
        return violations;
    }
}

