/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.utils.ValidValuesFormatter;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.http.consts.HttpConstants;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class CloudConnectorVersionValidator
extends Validator {
    @Override
    protected ViolationSet proceedValidation(Properties properties) {
        String value;
        ViolationSet violations = new ViolationSet();
        if (properties.containsKey("CloudConnectorVersion") && !HttpConstants.allowedCloudConnectorVersions.contains(value = properties.getProperty("CloudConnectorVersion").trim())) {
            violations.add(new Violation(ViolationType.CLOUD_CONNECTOR_VERSION_NOT_VALID, Messages.getMessage("ValueIsNotInAllowedRange", value, "CloudConnectorVersion", ValidValuesFormatter.format(HttpConstants.allowedCloudConnectorVersions)), Severity.ERROR));
            return violations;
        }
        return violations;
    }
}

