/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.http.consts.HttpConstants;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

class GenericHttpUrlValidator
extends Validator {
    private String propertyName;
    private ViolationType typeMissing;
    private ViolationType typeIncorrectProtocol;
    private ViolationType typeHostMissing;
    private ViolationType typeInvalidSyntax;

    GenericHttpUrlValidator(String propertyName, ViolationType typeMissing, ViolationType typeIncorrectProtocol, ViolationType typeHostMissing, ViolationType typeInvalidSyntax) {
        this.propertyName = propertyName;
        this.typeMissing = typeMissing;
        this.typeIncorrectProtocol = typeIncorrectProtocol;
        this.typeHostMissing = typeHostMissing;
        this.typeInvalidSyntax = typeInvalidSyntax;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (!properties.containsKey(this.propertyName) || properties.getProperty(this.propertyName).trim().isEmpty()) {
            violations.add(new Violation(this.typeMissing, Messages.getMessage("ValueIsEmptyString", this.propertyName), Severity.ERROR));
            return violations;
        }
        String value = properties.getProperty(this.propertyName).trim();
        violations.addSet(this.validateURL(value));
        return violations;
    }

    private ViolationSet validateURL(String value) {
        ViolationSet violations = new ViolationSet();
        try {
            URL url = new URL(value);
            String protocol = url.getProtocol();
            String host = url.getHost();
            if (protocol == null || !HttpConstants.ALLOWED_PROTOCOLS.contains(protocol.toLowerCase())) {
                violations.add(new Violation(this.typeIncorrectProtocol, Messages.getMessage("InvalidURLProtocolErrorMSG", new Object[0]), Severity.ERROR));
                return violations;
            }
            if (!value.toLowerCase().startsWith(String.valueOf(protocol.toLowerCase()) + "://")) {
                violations.add(new Violation(this.typeInvalidSyntax, Messages.getMessage("UriNotValid", value), Severity.ERROR));
                return violations;
            }
            if (host == null) {
                violations.add(new Violation(this.typeHostMissing, Messages.getMessage("InvalidURLHostErrorMSG", value), Severity.ERROR));
                return violations;
            }
        }
        catch (MalformedURLException malformedURLException) {
            violations.add(new Violation(this.typeIncorrectProtocol, Messages.getMessage("InvalidURLProtocolErrorMSG", new Object[0]), Severity.ERROR));
            return violations;
        }
        return violations;
    }
}

