/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

class GenericOAuth2SAMLBearerAssertionPropertyValidator
extends Validator {
    private String propertyName;
    private ViolationType typeRedundant;
    private boolean isRequired;
    private ViolationType typeMissing;

    GenericOAuth2SAMLBearerAssertionPropertyValidator(String propertyName, ViolationType typeRedundant) {
        this(propertyName, false, typeRedundant, null);
    }

    GenericOAuth2SAMLBearerAssertionPropertyValidator(String propertyName, boolean isRequired, ViolationType typeRedundant, ViolationType typeMissing) {
        this.propertyName = propertyName;
        this.isRequired = isRequired;
        this.typeRedundant = typeRedundant;
        this.typeMissing = typeMissing;
        if (isRequired && typeMissing == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        String authentication;
        ViolationSet violations = new ViolationSet();
        String string = authentication = properties.containsKey("Authentication") ? properties.getProperty("Authentication").trim() : null;
        if (authentication == null || !authentication.equals("OAuth2SAMLBearerAssertion")) {
            if (properties.containsKey(this.propertyName)) {
                violations.add(new Violation(this.typeRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", this.propertyName, "Authentication", "OAuth2SAMLBearerAssertion"), Severity.WARNING));
                return violations;
            }
        } else if (this.isRequired) {
            String propertyValue = properties.getProperty(this.propertyName);
            if (propertyValue == null) {
                violations.add(new Violation(this.typeMissing, Messages.getMessage("MissingRequiredAuthenticationRelatedProperty", "OAuth2SAMLBearerAssertion", this.propertyName), Severity.ERROR));
                return violations;
            }
            if (!propertyValue.matches(".*\\S.*")) {
                violations.add(new Violation(this.typeMissing, Messages.getMessage("ValueIsEmptyString", this.propertyName), Severity.ERROR));
                return violations;
            }
        }
        return violations;
    }
}

