/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

class GenericSAPAssertionSSOPropertyValidator
extends Validator {
    private String propertyName;
    private ViolationType typeMissing;
    private ViolationType typeRedundant;
    private ViolationType typeNotValid;
    private String regex;

    GenericSAPAssertionSSOPropertyValidator(String propertyName, ViolationType typeMissing, ViolationType typeRedundant, ViolationType typeNotValid, String regex) {
        this.propertyName = propertyName;
        this.typeMissing = typeMissing;
        this.typeRedundant = typeRedundant;
        this.typeNotValid = typeNotValid;
        this.regex = regex;
    }

    @Override
    public ViolationSet proceedValidation(Properties properties) {
        ViolationSet violations = new ViolationSet();
        if (!properties.containsKey("Authentication") && properties.containsKey(this.propertyName)) {
            violations.add(new Violation(ViolationType.AUTHENTICATION_MISSING, Messages.getMessage("MandatoryPropertyMissingNeededToCheckAnotherProperty", "Authentication", this.propertyName), Severity.WARNING));
            return violations;
        }
        if (properties.containsKey("Authentication")) {
            String authentication = properties.getProperty("Authentication").trim();
            if (authentication.equals("SAPAssertionSSO")) {
                if (!properties.containsKey(this.propertyName)) {
                    violations.add(new Violation(this.typeMissing, Messages.getMessage("MissingRequiredAuthenticationRelatedProperty", "SAPAssertionSSO", this.propertyName), Severity.ERROR));
                    return violations;
                }
                String propertyValue = properties.getProperty(this.propertyName).trim();
                if (!propertyValue.matches(this.regex)) {
                    String message = null;
                    message = this.propertyName.contains("SID") ? Messages.getMessage("RfcNotValidCharFormat", this.propertyName, 3) : (this.propertyName.contains("Client") ? Messages.getMessage("RfcNotValidFormat", this.propertyName, 3) : Messages.getMessage("SAPAssertionSSORelatedPropertyValidRegEx", this.propertyName));
                    violations.add(new Violation(this.typeNotValid, message, Severity.ERROR));
                    return violations;
                }
            } else if (properties.containsKey(this.propertyName)) {
                violations.add(new Violation(this.typeRedundant, Messages.getMessage("PropertyRedundantBecauseOfAnotherProperty", this.propertyName, "Authentication", "SAPAssertionSSO"), Severity.WARNING));
                return violations;
            }
        }
        return violations;
    }
}

