/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.utils.destinations.validation.validators.http;

import com.sap.core.utils.destinations.validation.i18n.Messages;
import com.sap.core.utils.destinations.validation.utils.ValidValuesFormatter;
import com.sap.core.utils.destinations.validation.validators.Validator;
import com.sap.core.utils.destinations.validation.validators.http.consts.HttpConstants;
import com.sap.core.utils.destinations.validation.violations.Severity;
import com.sap.core.utils.destinations.validation.violations.Violation;
import com.sap.core.utils.destinations.validation.violations.ViolationSet;
import com.sap.core.utils.destinations.validation.violations.ViolationType;
import java.util.Properties;

public class HostnameVerifierValidator
extends Validator {
    @Override
    public ViolationSet proceedValidation(Properties properties) {
        String value;
        ViolationSet violations = new ViolationSet();
        if (!properties.containsKey("HostnameVerifier")) {
            return violations;
        }
        if (properties.containsKey("TrustAll")) {
            String trustAllValue = properties.getProperty("TrustAll").trim();
            boolean trustAll = false;
            if (trustAllValue.toLowerCase().equals("true")) {
                trustAll = true;
            }
            if (trustAll && properties.containsKey("HostnameVerifier")) {
                violations.add(new Violation(ViolationType.HOSTNAME_VERIFIER_REDUNDANT, Messages.getMessage("TrustAllCausesPropertyRedundant", "HostnameVerifier"), Severity.WARNING));
                return violations;
            }
        }
        if (!HttpConstants.hostnameVerifiersAllowed.contains(value = properties.getProperty("HostnameVerifier").trim())) {
            violations.add(new Violation(ViolationType.HOSTNAME_VERIFIER_NOT_VALID, Messages.getMessage("ValueIsNotInAllowedRange", value, "HostnameVerifier", ValidValuesFormatter.format(HttpConstants.hostnameVerifiersAllowed)), Severity.ERROR));
            return violations;
        }
        return violations;
    }
}

